/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.BlockMasterClientPool;
import alluxio.client.block.BlockStoreContext;
import alluxio.client.block.BlockWorkerClient;
import alluxio.client.block.BlockWorkerClientPool;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BlockMasterClient.class, BlockMasterClientPool.class, BlockStoreContext.class, BlockWorkerClient.class, BlockWorkerClientPool.class})
public final class BlockStoreContextTest {
    @Before
    public void before() {
        BlockStoreContext.INSTANCE.reset();
    }

    @Test(timeout=10000L)
    public void acquireMasterLimitTest() throws Exception {
        ArrayList clients = Lists.newArrayList();
        for (int i = 0; i < ClientContext.getConf().getInt("alluxio.user.block.master.client.threads"); ++i) {
            clients.add(BlockStoreContext.INSTANCE.acquireMasterClient());
        }
        Thread acquireThread = new Thread(new AcquireMasterClient());
        acquireThread.start();
        long timeoutMs = 500L;
        long start = System.currentTimeMillis();
        acquireThread.join(timeoutMs);
        if (System.currentTimeMillis() - start < timeoutMs) {
            Assert.fail((String)"Acquired a master client when the client pool was full.");
        }
        for (BlockMasterClient client : clients) {
            BlockStoreContext.INSTANCE.releaseMasterClient(client);
        }
        timeoutMs = 5000L;
        start = System.currentTimeMillis();
        acquireThread.join(timeoutMs);
        if (System.currentTimeMillis() - start >= timeoutMs) {
            Assert.fail((String)("Failed to acquire a master client within " + timeoutMs + "ms. Deadlock?"));
        }
    }

    @Test(timeout=10000L)
    public void acquireWorkerLimitTest() throws Exception {
        BlockStoreContext.INSTANCE.reset();
        Whitebox.setInternalState(NetworkAddressUtils.class, (String)"sLocalHost", (Object)"localhost");
        BlockMasterClient masterClientMock = (BlockMasterClient)PowerMockito.mock(BlockMasterClient.class);
        ArrayList list = Lists.newArrayList();
        list.add(new WorkerInfo().setAddress(new WorkerNetAddress().setHost("localhost")));
        ((BlockMasterClient)PowerMockito.doReturn((Object)list).when((Object)masterClientMock)).getWorkerInfoList();
        PowerMockito.whenNew(BlockMasterClient.class).withArguments(Mockito.any(), new Object[]{Mockito.any()}).thenReturn((Object)masterClientMock);
        BlockWorkerClient workerClientMock = (BlockWorkerClient)PowerMockito.mock(BlockWorkerClient.class);
        ((BlockWorkerClient)PowerMockito.doNothing().when((Object)workerClientMock)).sessionHeartbeat();
        ((BlockWorkerClient)PowerMockito.doReturn((Object)true).when((Object)workerClientMock)).isLocal();
        PowerMockito.whenNew(BlockWorkerClient.class).withArguments(Mockito.any(), new Object[]{Mockito.any(), Mockito.any(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.any()}).thenReturn((Object)workerClientMock);
        ArrayList clients = Lists.newArrayList();
        Configuration conf = (Configuration)Whitebox.getInternalState(ClientContext.class, (String)"sConf");
        conf.set("alluxio.user.block.worker.client.threads", "10");
        for (int i = 0; i < ClientContext.getConf().getInt("alluxio.user.block.worker.client.threads"); ++i) {
            clients.add(BlockStoreContext.INSTANCE.acquireWorkerClient());
        }
        Thread acquireThread = new Thread(new AcquireWorkerClient());
        acquireThread.start();
        long timeoutMs = 500L;
        long start = System.currentTimeMillis();
        acquireThread.join(timeoutMs);
        if (System.currentTimeMillis() - start < timeoutMs) {
            Assert.fail((String)"Acquired a worker client when the client pool was full.");
        }
        for (BlockWorkerClient client : clients) {
            BlockStoreContext.INSTANCE.releaseWorkerClient(client);
        }
        timeoutMs = 5000L;
        start = System.currentTimeMillis();
        acquireThread.join(timeoutMs);
        if (System.currentTimeMillis() - start >= timeoutMs) {
            Assert.fail((String)("Failed to acquire a worker client within " + timeoutMs + "ms. Deadlock?"));
        }
    }

    class AcquireWorkerClient
    implements Runnable {
        AcquireWorkerClient() {
        }

        @Override
        public void run() {
            BlockWorkerClient client = BlockStoreContext.INSTANCE.acquireWorkerClient();
            BlockStoreContext.INSTANCE.releaseWorkerClient(client);
        }
    }

    class AcquireMasterClient
    implements Runnable {
        AcquireMasterClient() {
        }

        @Override
        public void run() {
            BlockMasterClient client = BlockStoreContext.INSTANCE.acquireMasterClient();
            BlockStoreContext.INSTANCE.releaseMasterClient(client);
        }
    }
}

