/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.BlockStoreContext;
import alluxio.exception.ExceptionMessage;
import alluxio.thrift.BlockMasterClientService;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BlockMasterClient.class})
public class BlockMasterClientTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unsupportedVersionTest() throws Exception {
        BlockMasterClientService.Client mock = (BlockMasterClientService.Client)PowerMockito.mock(BlockMasterClientService.Client.class);
        PowerMockito.when((Object)mock.getServiceVersion()).thenReturn((Object)0L);
        BlockMasterClient client = BlockStoreContext.INSTANCE.acquireMasterClient();
        try {
            Whitebox.invokeMethod((Object)client, (String)"checkVersion", (Object[])new Object[]{mock, 1L});
            Assert.fail((String)"checkVersion() should fail");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)ExceptionMessage.INCOMPATIBLE_VERSION.getMessage(new Object[]{"BlockMasterClient", 1L, 0}), (Object)e.getMessage());
        }
        finally {
            BlockStoreContext.INSTANCE.releaseMasterClient(client);
        }
    }
}

