/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Configuration;
import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.BlockStoreContext;
import alluxio.client.block.BlockWorkerClient;
import alluxio.client.block.BufferedBlockInStream;
import alluxio.client.block.LocalBlockInStream;
import alluxio.client.block.RemoteBlockInStream;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.LockBlockResult;
import alluxio.wire.WorkerNetAddress;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BlockMasterClient.class, BlockStoreContext.class, NetworkAddressUtils.class, BlockWorkerClient.class})
public final class AlluxioBlockStoreTest {
    private static final long BLOCK_ID = 3L;
    private static final long BLOCK_LENGTH = 1000L;
    private static final long LOCK_ID = 44L;
    private static final long WORKER_ID_LOCAL = 5L;
    private static final long WORKER_ID_REMOTE = 6L;
    private static final String WORKER_HOSTNAME_LOCAL = "localhost";
    private static final String WORKER_HOSTNAME_REMOTE = "remote";
    private static final int WORKER_RPC_PORT = 7;
    private static final int WORKER_DATA_PORT = 9;
    private static final int WORKER_WEB_PORT = 10;
    private static final WorkerNetAddress WORKER_NET_ADDRESS_LOCAL = new WorkerNetAddress().setHost("localhost").setRpcPort(7).setDataPort(9).setWebPort(10);
    private static final WorkerNetAddress WORKER_NET_ADDRESS_REMOTE = new WorkerNetAddress().setHost("remote").setRpcPort(7).setDataPort(9).setWebPort(10);
    private static final String STORAGE_TIER = "mem";
    private static final BlockLocation BLOCK_LOCATION_LOCAL = new BlockLocation().setWorkerId(5L).setWorkerAddress(WORKER_NET_ADDRESS_LOCAL).setTierAlias("mem");
    private static final BlockLocation BLOCK_LOCATION_REMOTE = new BlockLocation().setWorkerId(6L).setWorkerAddress(WORKER_NET_ADDRESS_REMOTE).setTierAlias("mem");
    private static final BlockInfo BLOCK_INFO = new BlockInfo().setBlockId(3L).setLength(1000L).setLocations(Arrays.asList(BLOCK_LOCATION_REMOTE, BLOCK_LOCATION_LOCAL));
    @Rule
    public TemporaryFolder mTestFolder = new TemporaryFolder();
    private static BlockStoreContext sBlockStoreContext;
    private static AlluxioBlockStore sBlockStore;
    private static BlockMasterClient sMasterClient;
    private static BlockWorkerClient sBlockWorkerClient;
    private File mTestFile;

    @BeforeClass
    public static void beforeClass() throws Exception {
        sBlockStoreContext = (BlockStoreContext)PowerMockito.mock(BlockStoreContext.class);
        Whitebox.setInternalState(BlockStoreContext.class, (String)"INSTANCE", (Object)sBlockStoreContext);
        sBlockWorkerClient = (BlockWorkerClient)PowerMockito.mock(BlockWorkerClient.class);
        Mockito.when((Object)sBlockStoreContext.acquireWorkerClient(Mockito.anyString())).thenReturn((Object)sBlockWorkerClient);
        sMasterClient = (BlockMasterClient)PowerMockito.mock(BlockMasterClient.class);
        Mockito.when((Object)sBlockStoreContext.acquireMasterClient()).thenReturn((Object)sMasterClient);
        sBlockStore = AlluxioBlockStore.get();
        Whitebox.setInternalState((Object)sBlockStore, (String)"mContext", (Object)sBlockStoreContext);
    }

    @Before
    public void before() throws Exception {
        this.mTestFile = this.mTestFolder.newFile("testFile");
        Mockito.when((Object)sBlockWorkerClient.lockBlock(3L)).thenReturn((Object)new LockBlockResult().setLockId(44L).setBlockPath(this.mTestFile.getAbsolutePath()));
    }

    @Test
    public void getInStreamLocalTest() throws Exception {
        Mockito.when((Object)sMasterClient.getBlockInfo(3L)).thenReturn((Object)BLOCK_INFO);
        PowerMockito.mockStatic(NetworkAddressUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)NetworkAddressUtils.getLocalHostName((Configuration)((Configuration)Mockito.any()))).thenReturn((Object)WORKER_HOSTNAME_LOCAL);
        BufferedBlockInStream stream = sBlockStore.getInStream(3L);
        Assert.assertTrue((boolean)(stream instanceof LocalBlockInStream));
        Assert.assertEquals((Object)3L, (Object)Whitebox.getInternalState((Object)stream, (String)"mBlockId"));
        Assert.assertEquals((Object)1000L, (Object)Whitebox.getInternalState((Object)stream, (String)"mBlockSize"));
    }

    @Test
    public void getInStreamRemoteTest() throws Exception {
        Mockito.when((Object)sMasterClient.getBlockInfo(3L)).thenReturn((Object)BLOCK_INFO);
        PowerMockito.mockStatic(NetworkAddressUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)NetworkAddressUtils.getLocalHostName((Configuration)((Configuration)Mockito.any()))).thenReturn((Object)"localhost_different");
        BufferedBlockInStream stream = sBlockStore.getInStream(3L);
        Assert.assertTrue((boolean)(stream instanceof RemoteBlockInStream));
        Assert.assertEquals((Object)3L, (Object)Whitebox.getInternalState((Object)stream, (String)"mBlockId"));
        Assert.assertEquals((Object)1000L, (Object)Whitebox.getInternalState((Object)stream, (String)"mBlockSize"));
        Assert.assertEquals((Object)new InetSocketAddress(WORKER_HOSTNAME_REMOTE, 9), (Object)Whitebox.getInternalState((Object)stream, (String)"mLocation"));
    }
}

