/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AliasInterceptor
extends AroundInterceptor {
    private static final Log log = LogFactory.getLog((Class)AliasInterceptor.class);
    private static final String DEFAULT_ALIAS_KEY = "aliases";
    protected String aliasesKey = "aliases";

    public void setAliasesKey(String aliasesKey) {
        this.aliasesKey = aliasesKey;
    }

    public void destroy() {
    }

    public void init() {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        ActionConfig config = invocation.getProxy().getConfig();
        ActionContext ac = invocation.getInvocationContext();
        Map parameters = config.getParams();
        if (parameters.containsKey(this.aliasesKey)) {
            String aliasExpression = (String)parameters.get(this.aliasesKey);
            OgnlValueStack stack = ac.getValueStack();
            Object obj = stack.findValue(aliasExpression);
            if (obj != null && obj instanceof Map) {
                Map aliases = (Map)obj;
                Iterator itr = aliases.entrySet().iterator();
                while (itr.hasNext()) {
                    Map contextParameters;
                    Map.Entry entry = itr.next();
                    String name = entry.getKey().toString();
                    String alias = (String)entry.getValue();
                    Object value = stack.findValue(name);
                    if (null == value && null != (contextParameters = (Map)stack.getContext().get("parameters"))) {
                        value = contextParameters.get(name);
                    }
                    if (null == value) continue;
                    stack.setValue(alias, value);
                }
            } else {
                log.debug((Object)("invalid alias expression:" + this.aliasesKey));
            }
        }
    }

    protected void after(ActionInvocation invocation, String result) throws Exception {
    }
}

