/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.Authenticator;
import org.mortbay.http.BasicAuthenticator;
import org.mortbay.http.ClientCertAuthenticator;
import org.mortbay.http.DigestAuthenticator;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FormAuthenticator;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlParser;

public class XMLConfiguration
implements WebApplicationContext.Configuration {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$XMLConfiguration == null ? (class$org$mortbay$jetty$servlet$XMLConfiguration = XMLConfiguration.class$("org.mortbay.jetty.servlet.XMLConfiguration")) : class$org$mortbay$jetty$servlet$XMLConfiguration));
    private WebApplicationContext _context;
    protected XmlParser xmlParser = XMLConfiguration.webXmlParser();
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$XMLConfiguration;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$WebApplicationContext;

    public static XmlParser webXmlParser() {
        XmlParser xmlParser = new XmlParser();
        URL dtd22 = (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = XMLConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/resources/web-app_2_2.dtd");
        URL dtd23 = (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = XMLConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/resources/web-app_2_3.dtd");
        URL jsp20xsd = (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = XMLConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/resources/jsp_2_0.xsd");
        URL j2ee14xsd = (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = XMLConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/resources/j2ee_1_4.xsd");
        URL webapp24xsd = (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = XMLConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/resources/web-app_2_4.xsd");
        URL schemadtd = (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = XMLConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/resources/XMLSchema.dtd");
        URL xmlxsd = (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = XMLConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/resources/xml.xsd");
        URL webservice11xsd = (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = XMLConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/resources/j2ee_web_services_client_1_1.xsd");
        URL datatypesdtd = (class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = XMLConfiguration.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext).getResource("/javax/servlet/resources/datatypes.dtd");
        xmlParser.redirectEntity("web-app_2_2.dtd", dtd22);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
        xmlParser.redirectEntity("web.dtd", dtd23);
        xmlParser.redirectEntity("web-app_2_3.dtd", dtd23);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
        xmlParser.redirectEntity("XMLSchema.dtd", schemadtd);
        xmlParser.redirectEntity("http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
        xmlParser.redirectEntity("-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
        xmlParser.redirectEntity("jsp_2_0.xsd", jsp20xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
        xmlParser.redirectEntity("j2ee_1_4.xsd", j2ee14xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
        xmlParser.redirectEntity("web-app_2_4.xsd", webapp24xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
        xmlParser.redirectEntity("xml.xsd", xmlxsd);
        xmlParser.redirectEntity("http://www.w3.org/2001/xml.xsd", xmlxsd);
        xmlParser.redirectEntity("datatypes.dtd", datatypesdtd);
        xmlParser.redirectEntity("http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
        xmlParser.redirectEntity("j2ee_web_services_client_1_1.xsd", webservice11xsd);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
        return xmlParser;
    }

    public void setWebApplicationContext(WebApplicationContext context) {
        this._context = context;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this._context;
    }

    public WebApplicationHandler getWebApplicationHandler() {
        return this._context.getWebApplicationHandler();
    }

    public void configureClassPath() throws Exception {
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot configure webapp after it is started");
            }
            return;
        }
        Resource webInf = this._context.getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource classes = webInf.addPath("classes/");
            if (classes.exists()) {
                this._context.setClassPath(classes.toString());
            } else {
                this._context.setClassPath(null);
            }
            Resource lib = webInf.addPath("lib/");
            this._context.addClassPaths(lib);
        }
    }

    public void configureDefaults() throws Exception {
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot configure webapp after it is started");
            }
            return;
        }
        String defaultsDescriptor = this.getWebApplicationContext().getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = Resource.newSystemResource(defaultsDescriptor);
            if (dftResource == null) {
                dftResource = Resource.newResource(defaultsDescriptor);
            }
            XmlParser.Node defaultConfig = this.xmlParser.parse(dftResource.getURL());
            this.initialize(defaultConfig);
        }
    }

    public void configureWebApp() throws Exception {
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot configure webapp after it is started");
            }
            return;
        }
        Resource webInf = this.getWebApplicationContext().getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource web = webInf.addPath("web.xml");
            if (!web.exists()) {
                log.info((Object)("No WEB-INF/web.xml in " + this.getWebApplicationContext().getWAR() + ". Serving files and default/dynamic servlets only"));
            } else {
                XmlParser.Node config = null;
                config = this.xmlParser.parse(web.getURL());
                this.initialize(config);
            }
        }
    }

    protected void initialize(XmlParser.Node config) throws ClassNotFoundException, UnavailableException {
        Iterator iter = config.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            try {
                Object o = iter.next();
                if (!(o instanceof XmlParser.Node)) continue;
                node = (XmlParser.Node)o;
                String name = node.getTag();
                this.initWebXmlElement(name, node);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                log.warn((Object)("Configuration problem at " + node), (Throwable)e);
                throw new UnavailableException("Configuration problem");
            }
        }
    }

    protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
        if ("display-name".equals(element)) {
            this.initDisplayName(node);
        } else if (!"description".equals(element)) {
            if ("context-param".equals(element)) {
                this.initContextParam(node);
            } else if ("servlet".equals(element)) {
                this.initServlet(node);
            } else if ("servlet-mapping".equals(element)) {
                this.initServletMapping(node);
            } else if ("session-config".equals(element)) {
                this.initSessionConfig(node);
            } else if ("mime-mapping".equals(element)) {
                this.initMimeConfig(node);
            } else if ("welcome-file-list".equals(element)) {
                this.initWelcomeFileList(node);
            } else if ("locale-encoding-mapping-list".equals(element)) {
                this.initLocaleEncodingList(node);
            } else if ("error-page".equals(element)) {
                this.initErrorPage(node);
            } else if ("taglib".equals(element)) {
                this.initTagLib(node);
            } else if ("jsp-config".equals(element)) {
                this.initJspConfig(node);
            } else if ("resource-ref".equals(element)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No implementation: " + node));
                }
            } else if ("security-constraint".equals(element)) {
                this.initSecurityConstraint(node);
            } else if ("login-config".equals(element)) {
                this.initLoginConfig(node);
            } else if ("security-role".equals(element)) {
                this.initSecurityRole(node);
            } else if ("filter".equals(element)) {
                this.initFilter(node);
            } else if ("filter-mapping".equals(element)) {
                this.initFilterMapping(node);
            } else if ("listener".equals(element)) {
                this.initListener(node);
            } else if ("distributable".equals(element)) {
                this.initDistributable(node);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Element " + element + " not handled in " + this));
                log.debug((Object)node);
            }
        }
    }

    protected void initDisplayName(XmlParser.Node node) {
        this.getWebApplicationContext().setDisplayName(node.toString(false, true));
    }

    protected void initContextParam(XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ContextParam: " + name + "=" + value));
        }
        this.getWebApplicationContext().setInitParameter(name, value);
    }

    protected void initFilter(XmlParser.Node node) throws ClassNotFoundException, UnavailableException {
        String name = node.getString("filter-name", false, true);
        String className = node.getString("filter-class", false, true);
        if (className == null) {
            log.warn((Object)("Missing filter-class in " + node));
            return;
        }
        if (name == null) {
            name = className;
        }
        FilterHolder holder = this.getWebApplicationHandler().defineFilter(name, className);
        Iterator iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.put(pname, pvalue);
        }
    }

    protected void initFilterMapping(XmlParser.Node node) {
        String filterName = node.getString("filter-name", false, true);
        String pathSpec = node.getString("url-pattern", false, true);
        String servletName = node.getString("servlet-name", false, true);
        int dispatcher = 0;
        Iterator iter = node.iterator("dispatcher");
        while (iter.hasNext()) {
            String d = ((XmlParser.Node)iter.next()).toString(false, true);
            dispatcher |= Dispatcher.type(d);
        }
        FilterHolder holder = servletName != null ? this.getWebApplicationHandler().addFilterServletMapping(servletName, filterName, dispatcher) : this.getWebApplicationHandler().addFilterPathMapping(pathSpec, filterName, dispatcher);
    }

    protected void initServlet(XmlParser.Node node) throws ClassNotFoundException, UnavailableException, IOException, MalformedURLException {
        String roleName;
        String name = node.getString("servlet-name", false, true);
        String className = node.getString("servlet-class", false, true);
        String jspFile = null;
        if (className == null) {
            Map.Entry entry;
            jspFile = node.getString("jsp-file", false, true);
            if (jspFile != null && (entry = this.getWebApplicationHandler().getHolderEntry(jspFile)) != null) {
                className = ((ServletHolder)entry.getValue()).getClassName();
            }
            if (className == null) {
                log.warn((Object)("Missing servlet-class|jsp-file in " + node));
                return;
            }
        }
        if (name == null) {
            name = className;
        }
        ServletHolder holder = this.getWebApplicationHandler().newServletHolder(name, className, jspFile);
        if (jspFile != null) {
            holder.setInitParameter("classpath", this.getWebApplicationContext().getFileClassPath());
        }
        Iterator iParamsIter = node.iterator("init-param");
        while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.put(pname, pvalue);
        }
        XmlParser.Node startup = node.get("load-on-startup");
        if (startup != null) {
            String s = startup.toString(false, true).toLowerCase();
            if (s.startsWith("t")) {
                log.warn((Object)"Deprecated boolean load-on-startup.  Please use integer");
                holder.setInitOrder(1);
            } else {
                int order = 0;
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Cannot parse load-on-startup " + s + ". Please use integer"));
                    LogSupport.ignore(log, e);
                }
                holder.setInitOrder(order);
            }
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("link role " + roleName + " to " + roleLink + " for " + this));
                }
                holder.setUserRoleLink(roleName, roleLink);
                continue;
            }
            log.warn((Object)("Ignored invalid security-role-ref element: servlet-name=" + name + ", " + securityRef));
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            holder.setRunAs(roleName);
        }
    }

    protected void initServletMapping(XmlParser.Node node) {
        String name = node.getString("servlet-name", false, true);
        String pathSpec = node.getString("url-pattern", false, true);
        this.getWebApplicationHandler().mapPathToServlet(pathSpec, name);
    }

    protected void initListener(XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        Object listener = null;
        try {
            Class listenerClass = this.getWebApplicationContext().loadClass(className);
            listener = listenerClass.newInstance();
        }
        catch (Exception e) {
            log.warn((Object)("Could not instantiate listener " + className), (Throwable)e);
            return;
        }
        if (!(listener instanceof EventListener)) {
            log.warn((Object)("Not an EventListener: " + listener));
            return;
        }
        boolean known = false;
        try {
            this.getWebApplicationContext().addEventListener(listener);
            known = true;
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
        }
        try {
            this.getWebApplicationHandler().addEventListener(listener);
            known = true;
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
        }
        if (!known) {
            log.warn((Object)("Unknown: " + listener));
        }
    }

    protected void initDistributable(XmlParser.Node node) {
        WebApplicationContext wac = this.getWebApplicationContext();
        if (!wac.isDistributable()) {
            wac.setDistributable(true);
        }
    }

    protected void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this.getWebApplicationHandler().setSessionInactiveInterval(timeout * 60);
        }
    }

    protected void initMimeConfig(XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        this.getWebApplicationContext().setMimeMapping(extension, mimeType);
    }

    protected void initWelcomeFileList(XmlParser.Node node) {
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String index = indexNode.toString(false, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Index: " + index));
            }
            this.getWebApplicationContext().addWelcomeFile(index);
        }
    }

    protected void initLocaleEncodingList(XmlParser.Node node) {
        Iterator iter = node.iterator("locale-encoding-mapping");
        while (iter.hasNext()) {
            XmlParser.Node mapping = (XmlParser.Node)iter.next();
            String locale = mapping.getString("locale", false, true);
            String encoding = mapping.getString("encoding", false, true);
            this.getWebApplicationContext().addLocaleEncoding(locale, encoding);
        }
    }

    protected void initErrorPage(XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        }
        String location = node.getString("location", false, true);
        this.getWebApplicationContext().setErrorPage(error, location);
    }

    protected void initTagLib(XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        this.getWebApplicationContext().setResourceAlias(uri, location);
    }

    protected void initJspConfig(XmlParser.Node node) {
        for (int i = 0; i < node.size(); ++i) {
            Object o = node.get(i);
            if (!(o instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)o).getTag())) continue;
            this.initTagLib((XmlParser.Node)o);
        }
    }

    protected void initSecurityConstraint(XmlParser.Node node) {
        try {
            XmlParser.Node data;
            SecurityConstraint scBase = new SecurityConstraint();
            XmlParser.Node auths = node.get("auth-constraint");
            if (auths != null) {
                scBase.setAuthenticate(true);
                Iterator iter = auths.iterator("role-name");
                while (iter.hasNext()) {
                    String role = ((XmlParser.Node)iter.next()).toString(false, true);
                    scBase.addRole(role);
                }
            }
            if ((data = node.get("user-data-constraint")) != null) {
                String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
                if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                    scBase.setDataConstraint(0);
                } else if ("INTEGRAL".equals(guarantee)) {
                    scBase.setDataConstraint(1);
                } else if ("CONFIDENTIAL".equals(guarantee)) {
                    scBase.setDataConstraint(2);
                } else {
                    log.warn((Object)("Unknown user-data-constraint:" + guarantee));
                    scBase.setDataConstraint(2);
                }
            }
            Iterator iter = node.iterator("web-resource-collection");
            while (iter.hasNext()) {
                XmlParser.Node collection = (XmlParser.Node)iter.next();
                String name = collection.getString("web-resource-name", false, true);
                SecurityConstraint sc = (SecurityConstraint)scBase.clone();
                sc.setName(name);
                Iterator iter2 = collection.iterator("http-method");
                while (iter2.hasNext()) {
                    sc.addMethod(((XmlParser.Node)iter2.next()).toString(false, true));
                }
                iter2 = collection.iterator("url-pattern");
                while (iter2.hasNext()) {
                    String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                    this.getWebApplicationContext().addSecurityConstraint(url, sc);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            log.fatal((Object)e);
        }
    }

    protected void initLoginConfig(XmlParser.Node node) {
        XmlParser.Node formConfig;
        XmlParser.Node name;
        XmlParser.Node method = node.get("auth-method");
        FormAuthenticator _formAuthenticator = null;
        if (method != null) {
            Authenticator authenticator = null;
            String m = method.toString(false, true);
            if ("FORM".equals(m)) {
                authenticator = _formAuthenticator = new FormAuthenticator();
            } else if ("BASIC".equals(m)) {
                authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equals(m)) {
                authenticator = new DigestAuthenticator();
            } else if ("CLIENT_CERT".equals(m)) {
                authenticator = new ClientCertAuthenticator();
            } else if ("CLIENT-CERT".equals(m)) {
                authenticator = new ClientCertAuthenticator();
            } else {
                log.warn((Object)("UNKNOWN AUTH METHOD: " + m));
            }
            this.getWebApplicationContext().setAuthenticator(authenticator);
        }
        if ((name = node.get("realm-name")) != null) {
            this.getWebApplicationContext().setRealmName(name.toString(false, true));
        }
        if ((formConfig = node.get("form-login-config")) != null) {
            if (_formAuthenticator == null) {
                log.warn((Object)"FORM Authentication miss-configured");
            } else {
                XmlParser.Node errorPage;
                XmlParser.Node loginPage = formConfig.get("form-login-page");
                if (loginPage != null) {
                    _formAuthenticator.setLoginPage(loginPage.toString(false, true));
                }
                if ((errorPage = formConfig.get("form-error-page")) != null) {
                    String ep = errorPage.toString(false, true);
                    _formAuthenticator.setErrorPage(ep);
                }
            }
        }
    }

    protected void initSecurityRole(XmlParser.Node node) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

