/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http.internal.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import zipkin.storage.elasticsearch.http.internal.client.Aggregation;

public final class SearchRequest {
    static final int MAX_RESULT_WINDOW = 10000;
    final transient List<String> indices;
    final transient String type;
    Integer size = 10000;
    Boolean _source;
    Object query;
    Map<String, Aggregation> aggs;

    SearchRequest(List<String> indices, String type) {
        this.indices = indices;
        this.type = type;
    }

    static NestedBoolQuery mustMatchAllNestedTerms(Map<String, String> next) {
        ArrayList<Term> terms = new ArrayList<Term>();
        String field = null;
        for (Map.Entry<String, String> nestedTerm : next.entrySet()) {
            field = nestedTerm.getKey();
            terms.add(new Term(field, nestedTerm.getValue()));
        }
        return new NestedBoolQuery(field.substring(0, field.indexOf(46)), "must", terms);
    }

    public SearchRequest filters(Filters filters) {
        return this.query(new BoolQuery("must", filters));
    }

    static BoolQuery _nestedTermsEqual(Collection<String> nestedFields, String value) {
        ArrayList<NestedBoolQuery> conditions = new ArrayList<NestedBoolQuery>();
        for (String nestedField : nestedFields) {
            conditions.add(new NestedBoolQuery(nestedField.substring(0, nestedField.indexOf(46)), "must", new Term(nestedField, value)));
        }
        return new BoolQuery("should", conditions);
    }

    public static SearchRequest forIndicesAndType(List<String> indices, String type) {
        return new SearchRequest(indices, type);
    }

    public SearchRequest term(String field, String value) {
        return this.query(new Term(field, value));
    }

    public SearchRequest terms(String field, List<String> values) {
        return this.query(new Terms(field, values));
    }

    public SearchRequest addAggregation(Aggregation agg) {
        this.size = null;
        this._source = false;
        if (this.aggs == null) {
            this.aggs = new LinkedHashMap<String, Aggregation>();
        }
        this.aggs.put(agg.field, agg);
        return this;
    }

    String tag() {
        return this.aggs != null ? "aggregation" : "search";
    }

    SearchRequest query(Object filter) {
        this.query = Collections.singletonMap("bool", Collections.singletonMap("filter", filter));
        return this;
    }

    static class BoolQuery {
        final Map<String, Object> bool;

        BoolQuery(String op, Object clause) {
            this.bool = Collections.singletonMap(op, clause);
        }
    }

    static class NestedBoolQuery {
        final Map<String, Object> nested = new LinkedHashMap<String, Object>(2);

        NestedBoolQuery(String path, String condition, List<Term> terms) {
            this.nested.put("path", path);
            this.nested.put("query", new BoolQuery(condition, terms));
        }

        NestedBoolQuery(String path, String condition, Term term) {
            this.nested.put("path", path);
            this.nested.put("query", new BoolQuery(condition, term));
        }
    }

    static class Range {
        final Map<String, Bounds> range;

        Range(String field, long from, Long to) {
            this.range = Collections.singletonMap(field, new Bounds(from, to));
        }

        static class Bounds {
            final long from;
            final Long to;
            final boolean include_lower = true;
            final boolean include_upper = true;

            Bounds(long from, Long to) {
                this.from = from;
                this.to = to;
            }
        }
    }

    static class Terms {
        final Map<String, List<String>> terms;

        Terms(String field, List<String> values) {
            this.terms = Collections.singletonMap(field, values);
        }
    }

    static class Term {
        final Map<String, String> term;

        Term(String field, String value) {
            this.term = Collections.singletonMap(field, value);
        }
    }

    public static class Filters
    extends LinkedList<Object> {
        public Filters addRange(String field, long from, Long to) {
            this.add(new Range(field, from, to));
            return this;
        }

        public Filters addTerm(String field, String value) {
            this.add(new Term(field, value));
            return this;
        }

        public Filters addNestedTerms(Collection<String> nestedFields, String value) {
            this.add(SearchRequest._nestedTermsEqual(nestedFields, value));
            return this;
        }

        public Filters addNestedTerms(Map<String, String> ... nestedTerms) {
            if (nestedTerms.length == 1) {
                this.add(SearchRequest.mustMatchAllNestedTerms(nestedTerms[0]));
                return this;
            }
            ArrayList<NestedBoolQuery> nestedBoolQueries = new ArrayList<NestedBoolQuery>(nestedTerms.length);
            for (Map<String, String> next : nestedTerms) {
                nestedBoolQueries.add(SearchRequest.mustMatchAllNestedTerms(next));
            }
            this.add(new BoolQuery("should", nestedBoolQueries));
            return this;
        }
    }
}

