/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.guava;

import com.google.common.util.concurrent.Futures;
import java.util.List;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin.storage.guava.GuavaSpanStore;
import zipkin.storage.guava.InternalForwardingCallback;

final class InternalGuavaToAsyncSpanStoreAdapter
implements AsyncSpanStore {
    final GuavaSpanStore delegate;

    InternalGuavaToAsyncSpanStoreAdapter(GuavaSpanStore delegate) {
        this.delegate = (GuavaSpanStore)Util.checkNotNull((Object)delegate, (String)"delegate");
    }

    public void getTraces(QueryRequest request, Callback<List<List<Span>>> callback) {
        Futures.addCallback(this.delegate.getTraces(request), new InternalForwardingCallback<List<List<Span>>>(callback));
    }

    public void getTrace(long id, Callback<List<Span>> callback) {
        this.getTrace(0L, id, callback);
    }

    public void getTrace(long traceIdHigh, long traceIdLow, Callback<List<Span>> callback) {
        Futures.addCallback(this.delegate.getTrace(traceIdHigh, traceIdLow), new InternalForwardingCallback<List<Span>>(callback));
    }

    public void getRawTrace(long traceId, Callback<List<Span>> callback) {
        this.getRawTrace(0L, traceId, callback);
    }

    public void getRawTrace(long traceIdHigh, long traceIdLow, Callback<List<Span>> callback) {
        Futures.addCallback(this.delegate.getRawTrace(traceIdHigh, traceIdLow), new InternalForwardingCallback<List<Span>>(callback));
    }

    public void getServiceNames(Callback<List<String>> callback) {
        Futures.addCallback(this.delegate.getServiceNames(), new InternalForwardingCallback<List<String>>(callback));
    }

    public void getSpanNames(String serviceName, Callback<List<String>> callback) {
        Futures.addCallback(this.delegate.getSpanNames(serviceName), new InternalForwardingCallback<List<String>>(callback));
    }

    public void getDependencies(long endTs, @Nullable Long lookback, Callback<List<DependencyLink>> callback) {
        Futures.addCallback(this.delegate.getDependencies(endTs, lookback), new InternalForwardingCallback<List<DependencyLink>>(callback));
    }

    public String toString() {
        return this.delegate.toString();
    }
}

