/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.guava;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin.storage.guava.GuavaSpanStore;

final class InternalGuavaSpanStoreAdapter
implements GuavaSpanStore {
    final AsyncSpanStore delegate;

    InternalGuavaSpanStoreAdapter(AsyncSpanStore delegate) {
        this.delegate = (AsyncSpanStore)Util.checkNotNull((Object)delegate, (String)"delegate");
    }

    @Override
    public ListenableFuture<List<List<Span>>> getTraces(QueryRequest request) {
        CallbackListenableFuture result = new CallbackListenableFuture();
        this.delegate.getTraces(request, result);
        return result;
    }

    @Override
    @Deprecated
    public ListenableFuture<List<Span>> getTrace(long id) {
        return this.getTrace(0L, id);
    }

    @Override
    public ListenableFuture<List<Span>> getTrace(long traceIdHigh, long traceIdLow) {
        CallbackListenableFuture result = new CallbackListenableFuture();
        this.delegate.getTrace(traceIdHigh, traceIdLow, result);
        return result;
    }

    @Override
    @Deprecated
    public ListenableFuture<List<Span>> getRawTrace(long traceId) {
        return this.getRawTrace(0L, traceId);
    }

    @Override
    public ListenableFuture<List<Span>> getRawTrace(long traceIdHigh, long traceIdLow) {
        CallbackListenableFuture result = new CallbackListenableFuture();
        this.delegate.getRawTrace(traceIdHigh, traceIdLow, result);
        return result;
    }

    @Override
    public ListenableFuture<List<String>> getServiceNames() {
        CallbackListenableFuture result = new CallbackListenableFuture();
        this.delegate.getServiceNames(result);
        return result;
    }

    @Override
    public ListenableFuture<List<String>> getSpanNames(String serviceName) {
        CallbackListenableFuture result = new CallbackListenableFuture();
        this.delegate.getSpanNames(serviceName, result);
        return result;
    }

    @Override
    public ListenableFuture<List<DependencyLink>> getDependencies(long endTs, @Nullable Long lookback) {
        CallbackListenableFuture result = new CallbackListenableFuture();
        this.delegate.getDependencies(endTs, lookback, result);
        return result;
    }

    public String toString() {
        return this.delegate.toString();
    }

    static final class CallbackListenableFuture<V>
    extends AbstractFuture<V>
    implements Callback<V> {
        CallbackListenableFuture() {
        }

        public void onSuccess(@Nullable V value) {
            this.set(value);
        }

        public void onError(Throwable t) {
            this.setException(t);
        }
    }
}

