/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.guava;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.Callback;
import zipkin.storage.guava.GuavaSpanConsumer;

final class InternalGuavaSpanConsumerAdapter
implements GuavaSpanConsumer {
    final AsyncSpanConsumer delegate;

    InternalGuavaSpanConsumerAdapter(AsyncSpanConsumer delegate) {
        this.delegate = (AsyncSpanConsumer)Util.checkNotNull((Object)delegate, (String)"delegate");
    }

    @Override
    public ListenableFuture<Void> accept(List<Span> spans) {
        VoidListenableFuture result = new VoidListenableFuture();
        this.delegate.accept(spans, (Callback)result);
        return result;
    }

    public String toString() {
        return this.delegate.toString();
    }

    static final class VoidListenableFuture
    extends AbstractFuture<Void>
    implements Callback<Void> {
        VoidListenableFuture() {
        }

        public void onSuccess(@Nullable Void value) {
            this.set(value);
        }

        public void onError(Throwable t) {
            this.setException(t);
        }
    }
}

