/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.AutoValue_ServerTracer;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanState;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.internal.Nullable;
import com.github.kristofa.brave.internal.Util;
import java.util.Random;

public abstract class ServerTracer
extends AnnotationSubmitter {
    public static Builder builder() {
        return new AutoValue_ServerTracer.Builder();
    }

    @Override
    abstract SpanAndEndpoint.ServerSpanAndEndpoint spanAndEndpoint();

    abstract Random randomGenerator();

    abstract SpanCollector spanCollector();

    abstract Sampler traceSampler();

    public void clearCurrentSpan() {
        this.spanAndEndpoint().state().setCurrentServerSpan(null);
    }

    public void setStateCurrentTrace(long traceId, long spanId, @Nullable Long parentSpanId, @Nullable String name) {
        Util.checkNotBlank(name, "Null or blank span name", new Object[0]);
        this.spanAndEndpoint().state().setCurrentServerSpan(ServerSpan.create(traceId, spanId, parentSpanId, name));
    }

    public void setStateNoTracing() {
        this.spanAndEndpoint().state().setCurrentServerSpan(ServerSpan.NOT_SAMPLED);
    }

    public void setStateUnknown(String spanName) {
        Util.checkNotBlank(spanName, "Null or blank span name", new Object[0]);
        long newTraceId = this.randomGenerator().nextLong();
        if (!this.traceSampler().isSampled(newTraceId)) {
            this.spanAndEndpoint().state().setCurrentServerSpan(ServerSpan.NOT_SAMPLED);
            return;
        }
        this.spanAndEndpoint().state().setCurrentServerSpan(ServerSpan.create(newTraceId, newTraceId, null, spanName));
    }

    public void setServerReceived() {
        this.submitStartAnnotation("sr");
    }

    public void setServerReceived(int ipv4, int port, @Nullable String clientService) {
        this.submitAddress("ca", ipv4, port, clientService);
        this.submitStartAnnotation("sr");
    }

    public void setServerSend() {
        if (this.submitEndAnnotation("ss", this.spanCollector())) {
            this.spanAndEndpoint().state().setCurrentServerSpan(null);
        }
    }

    ServerTracer() {
    }

    public static abstract class Builder {
        public Builder state(ServerSpanState state) {
            return this.spanAndEndpoint(SpanAndEndpoint.ServerSpanAndEndpoint.create(state));
        }

        abstract Builder spanAndEndpoint(SpanAndEndpoint.ServerSpanAndEndpoint var1);

        public abstract Builder randomGenerator(Random var1);

        public abstract Builder spanCollector(SpanCollector var1);

        public abstract Builder traceSampler(Sampler var1);

        public abstract ServerTracer build();
    }
}

