/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.Sampler;
import java.util.Random;
import zipkin.internal.Util;

public final class BoundarySampler
extends Sampler {
    static final long SALT = new Random().nextLong();
    private final long boundary;

    public static Sampler create(float rate) {
        if (rate == 0.0f) {
            return Sampler.NEVER_SAMPLE;
        }
        if ((double)rate == 1.0) {
            return ALWAYS_SAMPLE;
        }
        Util.checkArgument((rate >= 1.0E-4f && rate < 1.0f ? 1 : 0) != 0, (String)"rate should be between 0.0001 and 1: was %s", (Object[])new Object[]{Float.valueOf(rate)});
        long boundary = (long)(rate * 10000.0f);
        return new BoundarySampler(boundary);
    }

    BoundarySampler(long boundary) {
        this.boundary = boundary;
    }

    @Override
    public boolean isSampled(long traceId) {
        long t = Math.abs(traceId ^ SALT);
        return t % 10000L <= this.boundary;
    }

    public String toString() {
        return "BoundaryTraceIdSampler(" + this.boundary + ")";
    }
}

