/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.system.impl;

import io.vertx.core.Handler;
import io.vertx.ext.shell.system.Job;
import io.vertx.ext.shell.system.JobController;
import io.vertx.ext.shell.system.Process;
import io.vertx.ext.shell.system.impl.JobImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class JobControllerImpl
implements JobController {
    Handler<Job> foregroundUpdatedHandler;
    Job foregroundJob;
    private final SortedMap<Integer, JobImpl> jobs = new TreeMap<Integer, JobImpl>();
    private boolean closed = false;

    @Override
    public Job foregroundJob() {
        return this.foregroundJob;
    }

    @Override
    public synchronized Set<Job> jobs() {
        return new HashSet<Job>(this.jobs.values());
    }

    @Override
    public synchronized Job getJob(int id) {
        return (Job)this.jobs.get(id);
    }

    synchronized boolean removeJob(int id) {
        return this.jobs.remove(id) != null;
    }

    public JobController foregroundUpdatedHandler(Handler<Job> handler) {
        this.foregroundUpdatedHandler = handler;
        return this;
    }

    @Override
    public Job createJob(Process process, String line) {
        int id = this.jobs.isEmpty() ? 1 : this.jobs.lastKey() + 1;
        JobImpl job = new JobImpl(id, this, process, line);
        this.jobs.put(id, job);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Handler<Void> completionHandler) {
        List<JobImpl> jobs;
        JobControllerImpl jobControllerImpl = this;
        synchronized (jobControllerImpl) {
            if (this.closed) {
                jobs = Collections.emptyList();
            } else {
                jobs = new ArrayList<JobImpl>(this.jobs.values());
                this.closed = true;
            }
        }
        if (jobs.isEmpty()) {
            completionHandler.handle(null);
        } else {
            AtomicInteger count = new AtomicInteger(jobs.size());
            jobs.forEach(job -> {
                job.terminateFuture.setHandler(v -> {
                    if (count.decrementAndGet() == 0 && completionHandler != null) {
                        completionHandler.handle(null);
                    }
                });
                job.terminate();
            });
        }
    }

    @Override
    public void close() {
        this.close(null);
    }
}

