/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.eventbus.Message;
import io.vertx.rxjava.core.eventbus.MessageConsumer;
import io.vertx.rxjava.core.eventbus.MessageProducer;
import io.vertx.rxjava.core.eventbus.SendContext;
import io.vertx.rxjava.core.metrics.Measured;
import rx.Observable;

public class EventBus
implements Measured {
    final io.vertx.core.eventbus.EventBus delegate;

    public EventBus(io.vertx.core.eventbus.EventBus delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public EventBus send(String address, Object message) {
        this.delegate.send(address, message);
        return this;
    }

    public <T> EventBus send(String address, Object message, final Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.send(address, message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle((Object)Future.succeededFuture((Object)Message.newInstance((io.vertx.core.eventbus.Message)ar.result())));
                } else {
                    replyHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public <T> Observable<Message<T>> sendObservable(String address, Object message) {
        ObservableFuture<Message<T>> replyHandler = RxHelper.observableFuture();
        this.send(address, message, replyHandler.toHandler());
        return replyHandler;
    }

    public EventBus send(String address, Object message, DeliveryOptions options) {
        this.delegate.send(address, message, options);
        return this;
    }

    public <T> EventBus send(String address, Object message, DeliveryOptions options, final Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.send(address, message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle((Object)Future.succeededFuture((Object)Message.newInstance((io.vertx.core.eventbus.Message)ar.result())));
                } else {
                    replyHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public <T> Observable<Message<T>> sendObservable(String address, Object message, DeliveryOptions options) {
        ObservableFuture<Message<T>> replyHandler = RxHelper.observableFuture();
        this.send(address, message, options, replyHandler.toHandler());
        return replyHandler;
    }

    public EventBus publish(String address, Object message) {
        this.delegate.publish(address, message);
        return this;
    }

    public EventBus publish(String address, Object message, DeliveryOptions options) {
        this.delegate.publish(address, message, options);
        return this;
    }

    public <T> MessageConsumer<T> consumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address));
        return ret;
    }

    public <T> MessageConsumer<T> consumer(String address, final Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address, new Handler<io.vertx.core.eventbus.Message<T>>(){

            public void handle(io.vertx.core.eventbus.Message<T> event) {
                handler.handle((Object)Message.newInstance(event));
            }
        }));
        return ret;
    }

    public <T> MessageConsumer<T> localConsumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address));
        return ret;
    }

    public <T> MessageConsumer<T> localConsumer(String address, final Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address, new Handler<io.vertx.core.eventbus.Message<T>>(){

            public void handle(io.vertx.core.eventbus.Message<T> event) {
                handler.handle((Object)Message.newInstance(event));
            }
        }));
        return ret;
    }

    public <T> MessageProducer<T> sender(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address));
        return ret;
    }

    public <T> MessageProducer<T> sender(String address, DeliveryOptions options) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address, options));
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address));
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address, options));
        return ret;
    }

    public EventBus addInterceptor(final Handler<SendContext> interceptor) {
        EventBus ret = EventBus.newInstance(this.delegate.addInterceptor((Handler)new Handler<io.vertx.core.eventbus.SendContext>(){

            public void handle(io.vertx.core.eventbus.SendContext event) {
                interceptor.handle((Object)SendContext.newInstance(event));
            }
        }));
        return ret;
    }

    public EventBus removeInterceptor(final Handler<SendContext> interceptor) {
        EventBus ret = EventBus.newInstance(this.delegate.removeInterceptor((Handler)new Handler<io.vertx.core.eventbus.SendContext>(){

            public void handle(io.vertx.core.eventbus.SendContext event) {
                interceptor.handle((Object)SendContext.newInstance(event));
            }
        }));
        return ret;
    }

    public static EventBus newInstance(io.vertx.core.eventbus.EventBus arg) {
        return arg != null ? new EventBus(arg) : null;
    }
}

