/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.ConnectionBase;

public abstract class VertxHandler<C extends ConnectionBase>
extends ChannelDuplexHandler {
    protected final VertxInternal vertx;
    protected final Map<Channel, C> connectionMap;

    protected VertxHandler(VertxInternal vertx, Map<Channel, C> connectionMap) {
        this.vertx = vertx;
        this.connectionMap = connectionMap;
    }

    protected DefaultContext getContext(C connection) {
        return ((ConnectionBase)connection).getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteBuf safeBuffer(ByteBuf buf, ByteBufAllocator allocator) {
        if (buf == Unpooled.EMPTY_BUFFER) {
            return buf;
        }
        if (buf.isDirect() || buf instanceof CompositeByteBuf) {
            try {
                if (buf.isReadable()) {
                    ByteBuf buffer = allocator.heapBuffer(buf.readableBytes());
                    buffer.writeBytes(buf);
                    ByteBuf byteBuf = buffer;
                    return byteBuf;
                }
                ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
                return byteBuf;
            }
            finally {
                buf.release();
            }
        }
        return buf;
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        Channel ch = ctx.channel();
        final ConnectionBase conn = (ConnectionBase)this.connectionMap.get(ch);
        if (conn != null) {
            conn.setWritable(ctx.channel().isWritable());
            DefaultContext context = this.getContext(conn);
            if (context.isOnCorrectWorker(ch.eventLoop())) {
                try {
                    this.vertx.setContext(context);
                    conn.handleInterestedOpsChanged();
                }
                catch (Throwable t) {
                    context.reportException(t);
                }
            } else {
                context.execute(new Runnable(){

                    @Override
                    public void run() {
                        conn.handleInterestedOpsChanged();
                    }
                });
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext chctx, final Throwable t) throws Exception {
        final Channel ch = chctx.channel();
        final ConnectionBase connection = (ConnectionBase)this.connectionMap.get(ch);
        if (connection != null) {
            DefaultContext context = this.getContext(connection);
            context.execute(ch.eventLoop(), new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ch.isOpen()) {
                            ch.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    connection.handleException(t);
                }
            });
        } else {
            ch.close();
        }
    }

    public void channelInactive(ChannelHandlerContext chctx) throws Exception {
        Channel ch = chctx.channel();
        final ConnectionBase connection = (ConnectionBase)this.connectionMap.remove(ch);
        if (connection != null) {
            DefaultContext context = this.getContext(connection);
            context.execute(ch.eventLoop(), new Runnable(){

                @Override
                public void run() {
                    connection.handleClosed();
                }
            });
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        DefaultContext context;
        ConnectionBase conn = (ConnectionBase)this.connectionMap.get(ctx.channel());
        if (conn != null && (context = this.getContext(conn)).isOnCorrectWorker(ctx.channel().eventLoop())) {
            conn.endReadAndFlush();
        }
    }

    public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
        DefaultContext context;
        Object message = this.safeObject(msg, chctx.alloc());
        ConnectionBase connection = (ConnectionBase)this.connectionMap.get(chctx.channel());
        if (connection != null) {
            context = this.getContext(connection);
            if (context.isOnCorrectWorker(chctx.channel().eventLoop())) {
                connection.startRead();
            }
        } else {
            context = null;
        }
        this.channelRead(connection, context, chctx, message);
    }

    protected abstract void channelRead(C var1, DefaultContext var2, ChannelHandlerContext var3, Object var4) throws Exception;

    protected abstract Object safeObject(Object var1, ByteBufAllocator var2) throws Exception;
}

