/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.vertx.core.json.JsonObject;
import io.vertx.docgen.Source;
import java.util.ArrayList;
import java.util.List;

@Source(translate=false)
public class WebServerOptions {
    private String host;
    private int port;
    private String root;
    private List<String> certificates;

    public WebServerOptions() {
        this.host = "localhost";
        this.port = 80;
        this.root = "content";
        this.certificates = new ArrayList<String>();
    }

    public WebServerOptions(WebServerOptions that) {
        this.host = that.host;
        this.port = that.port;
        this.root = that.root;
        this.certificates = new ArrayList<String>(that.certificates);
    }

    public WebServerOptions(JsonObject json) {
        this.host = json.getString("host", "localhost");
        this.port = json.getInteger("port", Integer.valueOf(80));
        this.root = json.getString("root", "content");
        this.certificates = json.getJsonArray("certificates") != null ? json.getJsonArray("certificates").getList() : new ArrayList();
    }

    public WebServerOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public WebServerOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public WebServerOptions setRoot(String root) {
        this.root = root;
        return this;
    }

    public WebServerOptions setCertificates(List<String> certificates) {
        this.certificates = certificates;
        return this;
    }

    public WebServerOptions addCertificate(String certificate) {
        this.certificates.add(certificate);
        return this;
    }
}

