/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.resource.internal;

import io.gravitee.plugin.resource.ResourcePlugin;
import io.gravitee.plugin.resource.ResourcePluginManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ResourcePluginManagerImpl
implements ResourcePluginManager {
    private static final String SCHEMAS_DIRECTORY = "schemas";
    private final Map<String, ResourcePlugin> definitions = new HashMap<String, ResourcePlugin>();

    @Override
    public void register(ResourcePlugin resourcePlugin) {
        this.definitions.put(resourcePlugin.id(), resourcePlugin);
    }

    @Override
    public Collection<ResourcePlugin> findAll() {
        return this.definitions.values();
    }

    @Override
    public ResourcePlugin get(String resource) {
        return this.definitions.get(resource);
    }

    @Override
    public String getConfiguration(String resource) throws IOException {
        File schemaDir;
        Path resourceWorkspace = this.get(resource).path();
        File[] schemas = resourceWorkspace.toFile().listFiles(pathname -> pathname.isDirectory() && pathname.getName().equals(SCHEMAS_DIRECTORY));
        if (schemas.length == 1 && (schemaDir = schemas[0]).listFiles().length > 0) {
            return new String(Files.readAllBytes(schemaDir.listFiles()[0].toPath()));
        }
        return null;
    }
}

