/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.resource.internal;

import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginHandler;
import io.gravitee.plugin.core.api.PluginType;
import io.gravitee.plugin.resource.ResourcePluginManager;
import io.gravitee.plugin.resource.internal.ResourceConfigurationClassFinder;
import io.gravitee.plugin.resource.internal.ResourcePluginImpl;
import java.io.IOException;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ClassUtils;

public class ResourcePluginHandler
implements PluginHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcePluginHandler.class);
    @Autowired
    private ResourcePluginManager resourcePluginManager;

    public boolean canHandle(Plugin plugin) {
        return PluginType.RESOURCE == plugin.type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Plugin plugin) {
        URLClassLoader resourceClassLoader = null;
        try {
            resourceClassLoader = new URLClassLoader(plugin.dependencies(), this.getClass().getClassLoader());
            Class pluginClass = ClassUtils.forName((String)plugin.clazz(), (ClassLoader)resourceClassLoader);
            LOGGER.info("Register a new resource: {} [{}]", (Object)plugin.id(), (Object)pluginClass.getName());
            ResourcePluginImpl resource = new ResourcePluginImpl(plugin, pluginClass);
            resource.setConfiguration(new ResourceConfigurationClassFinder().lookupFirst(pluginClass, resourceClassLoader));
            this.resourcePluginManager.register(resource);
        }
        catch (Exception iae) {
            LOGGER.error("Unexpected error while creating resource instance", (Throwable)iae);
        }
        finally {
            if (resourceClassLoader != null) {
                try {
                    resourceClassLoader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

