/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateFluentImpl;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.TemplateListFluent;
import java.util.ArrayList;
import java.util.List;

public class TemplateListFluentImpl<A extends TemplateListFluent<A>>
extends BaseFluent<A>
implements TemplateListFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends Template, ?>> items = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends ListMeta, ?> metadata;

    public TemplateListFluentImpl() {
    }

    public TemplateListFluentImpl(TemplateList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(Template ... items) {
        for (Template item : items) {
            TemplateBuilder builder = new TemplateBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Template ... items) {
        for (Template item : items) {
            TemplateBuilder builder = new TemplateBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<Template> getItems() {
        return TemplateListFluentImpl.build(this.items);
    }

    @Override
    public A withItems(List<Template> items) {
        this.items.clear();
        if (items != null) {
            for (Template item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(Template ... items) {
        this.items.clear();
        if (items != null) {
            for (Template item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public TemplateListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public TemplateListFluent.ItemsNested<A> addNewItemLike(Template item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public TemplateListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public TemplateListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public TemplateListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateListFluentImpl that = (TemplateListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<TemplateListFluent.MetadataNested<N>>
    implements TemplateListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TemplateListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends TemplateFluentImpl<TemplateListFluent.ItemsNested<N>>
    implements TemplateListFluent.ItemsNested<N>,
    Nested<N> {
        private final TemplateBuilder builder;

        ItemsNestedImpl() {
            this.builder = new TemplateBuilder(this);
        }

        ItemsNestedImpl(Template item) {
            this.builder = new TemplateBuilder(this, item);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)TemplateListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

