/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.ClusterRoleBuilder;
import io.fabric8.openshift.api.model.ClusterRoleFluentImpl;
import io.fabric8.openshift.api.model.NamedClusterRole;
import io.fabric8.openshift.api.model.NamedClusterRoleFluent;

public class NamedClusterRoleFluentImpl<A extends NamedClusterRoleFluent<A>>
extends BaseFluent<A>
implements NamedClusterRoleFluent<A> {
    private String name;
    private VisitableBuilder<? extends ClusterRole, ?> role;

    public NamedClusterRoleFluentImpl() {
    }

    public NamedClusterRoleFluentImpl(NamedClusterRole instance) {
        this.withName(instance.getName());
        this.withRole(instance.getRole());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public ClusterRole getRole() {
        return this.role != null ? (ClusterRole)this.role.build() : null;
    }

    @Override
    public A withRole(ClusterRole role) {
        if (role != null) {
            this.role = new ClusterRoleBuilder(role);
            this._visitables.add(this.role);
        }
        return (A)this;
    }

    @Override
    public NamedClusterRoleFluent.RoleNested<A> withNewRole() {
        return new RoleNestedImpl();
    }

    @Override
    public NamedClusterRoleFluent.RoleNested<A> withNewRoleLike(ClusterRole item) {
        return new RoleNestedImpl(item);
    }

    @Override
    public NamedClusterRoleFluent.RoleNested<A> editRole() {
        return this.withNewRoleLike(this.getRole());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterRoleFluentImpl that = (NamedClusterRoleFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.role != null ? !this.role.equals(that.role) : that.role != null);
    }

    public class RoleNestedImpl<N>
    extends ClusterRoleFluentImpl<NamedClusterRoleFluent.RoleNested<N>>
    implements NamedClusterRoleFluent.RoleNested<N>,
    Nested<N> {
        private final ClusterRoleBuilder builder;

        RoleNestedImpl() {
            this.builder = new ClusterRoleBuilder(this);
        }

        RoleNestedImpl(ClusterRole item) {
            this.builder = new ClusterRoleBuilder(this, item);
        }

        @Override
        public N endRole() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NamedClusterRoleFluentImpl.this.withRole(this.builder.build());
        }
    }
}

