/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.ImageStreamTagListFluent;
import java.util.ArrayList;
import java.util.List;

public class ImageStreamTagListFluentImpl<A extends ImageStreamTagListFluent<A>>
extends BaseFluent<A>
implements ImageStreamTagListFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends ImageStreamTag, ?>> items = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends ListMeta, ?> metadata;

    public ImageStreamTagListFluentImpl() {
    }

    public ImageStreamTagListFluentImpl(ImageStreamTagList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(ImageStreamTag ... items) {
        for (ImageStreamTag item : items) {
            ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ImageStreamTag ... items) {
        for (ImageStreamTag item : items) {
            ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ImageStreamTag> getItems() {
        return ImageStreamTagListFluentImpl.build(this.items);
    }

    @Override
    public A withItems(List<ImageStreamTag> items) {
        this.items.clear();
        if (items != null) {
            for (ImageStreamTag item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(ImageStreamTag ... items) {
        this.items.clear();
        if (items != null) {
            for (ImageStreamTag item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public ImageStreamTagListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ImageStreamTagListFluent.ItemsNested<A> addNewItemLike(ImageStreamTag item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ImageStreamTagListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageStreamTagListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageStreamTagListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamTagListFluentImpl that = (ImageStreamTagListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<ImageStreamTagListFluent.MetadataNested<N>>
    implements ImageStreamTagListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends ImageStreamTagFluentImpl<ImageStreamTagListFluent.ItemsNested<N>>
    implements ImageStreamTagListFluent.ItemsNested<N>,
    Nested<N> {
        private final ImageStreamTagBuilder builder;

        ItemsNestedImpl() {
            this.builder = new ImageStreamTagBuilder(this);
        }

        ItemsNestedImpl(ImageStreamTag item) {
            this.builder = new ImageStreamTagBuilder(this, item);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageStreamTagListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

