/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextBuilder;
import io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PodSpecFluentImpl<A extends PodSpecFluent<A>>
extends BaseFluent<A>
implements PodSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private List<VisitableBuilder<? extends Container, ?>> containers = new ArrayList();
    private String dnsPolicy;
    private String host;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private String hostname;
    private List<VisitableBuilder<? extends LocalObjectReference, ?>> imagePullSecrets = new ArrayList();
    private String nodeName;
    private Map<String, String> nodeSelector = new LinkedHashMap<String, String>();
    private String restartPolicy;
    private VisitableBuilder<? extends PodSecurityContext, ?> securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private List<VisitableBuilder<? extends Volume, ?>> volumes = new ArrayList();

    public PodSpecFluentImpl() {
    }

    public PodSpecFluentImpl(PodSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withContainers(instance.getContainers());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withHost(instance.getHost());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostname(instance.getHostname());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withNodeName(instance.getNodeName());
        this.withNodeSelector(instance.getNodeSelector());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSubdomain(instance.getSubdomain());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.remove(builder);
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<Container> getContainers() {
        return PodSpecFluentImpl.build(this.containers);
    }

    @Override
    public A withContainers(List<Container> containers) {
        this.containers.clear();
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        this.containers.clear();
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public PodSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(item);
    }

    @Override
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    @Override
    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean isHostIPC() {
        return this.hostIPC;
    }

    @Override
    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    @Override
    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean isHostPID() {
        return this.hostPID;
    }

    @Override
    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<LocalObjectReference> getImagePullSecrets() {
        return PodSpecFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(item);
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (key != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector.clear();
        if (nodeSelector != null) {
            this.nodeSelector.putAll(nodeSelector);
        }
        return (A)this;
    }

    @Override
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    @Override
    public PodSecurityContext getSecurityContext() {
        return this.securityContext != null ? (PodSecurityContext)this.securityContext.build() : null;
    }

    @Override
    public A withSecurityContext(PodSecurityContext securityContext) {
        if (securityContext != null) {
            this.securityContext = new PodSecurityContextBuilder(securityContext);
            this._visitables.add(this.securityContext);
        }
        return (A)this;
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public String getSubdomain() {
        return this.subdomain;
    }

    @Override
    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    @Override
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    @Override
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.remove(builder);
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return PodSpecFluentImpl.build(this.volumes);
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public PodSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSpecFluentImpl that = (PodSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.subdomain != null ? !this.subdomain.equals(that.subdomain) : that.subdomain != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != null ? !this.terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) : that.terminationGracePeriodSeconds != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<PodSpecFluent.VolumesNested<N>>
    implements PodSpecFluent.VolumesNested<N>,
    Nested<N> {
        private final VolumeBuilder builder;

        VolumesNestedImpl() {
            this.builder = new VolumeBuilder(this);
        }

        VolumesNestedImpl(Volume item) {
            this.builder = new VolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.addToVolumes(this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class SecurityContextNestedImpl<N>
    extends PodSecurityContextFluentImpl<PodSpecFluent.SecurityContextNested<N>>
    implements PodSpecFluent.SecurityContextNested<N>,
    Nested<N> {
        private final PodSecurityContextBuilder builder;

        SecurityContextNestedImpl() {
            this.builder = new PodSecurityContextBuilder(this);
        }

        SecurityContextNestedImpl(PodSecurityContext item) {
            this.builder = new PodSecurityContextBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.withSecurityContext(this.builder.build());
        }

        @Override
        public N endSecurityContext() {
            return this.and();
        }
    }

    public class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<PodSpecFluent.ImagePullSecretsNested<N>>
    implements PodSpecFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        ImagePullSecretsNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        ImagePullSecretsNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.addToImagePullSecrets(this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class ContainersNestedImpl<N>
    extends ContainerFluentImpl<PodSpecFluent.ContainersNested<N>>
    implements PodSpecFluent.ContainersNested<N>,
    Nested<N> {
        private final ContainerBuilder builder;

        ContainersNestedImpl() {
            this.builder = new ContainerBuilder(this);
        }

        ContainersNestedImpl(Container item) {
            this.builder = new ContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.addToContainers(this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }
}

