/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableImageStreamStatus;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.ImageStreamStatusFluent;
import io.fabric8.openshift.api.model.ImageStreamStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageStreamStatusBuilder
extends ImageStreamStatusFluentImpl<ImageStreamStatusBuilder>
implements VisitableBuilder<ImageStreamStatus, ImageStreamStatusBuilder> {
    ImageStreamStatusFluent<?> fluent;

    public ImageStreamStatusBuilder() {
        this(new ImageStreamStatus());
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent) {
        this(fluent, new ImageStreamStatus());
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent, ImageStreamStatus instance) {
        this.fluent = fluent;
        fluent.withDockerImageRepository(instance.getDockerImageRepository());
        fluent.withTags(instance.getTags());
    }

    public ImageStreamStatusBuilder(ImageStreamStatus instance) {
        this.fluent = this;
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withTags(instance.getTags());
    }

    @Override
    public EditableImageStreamStatus build() {
        EditableImageStreamStatus buildable = new EditableImageStreamStatus(this.fluent.getDockerImageRepository(), this.fluent.getTags());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamStatusBuilder that = (ImageStreamStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

