/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamListFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageStreamListFluentImpl<T extends ImageStreamListFluent<T>>
extends BaseFluent<T>
implements ImageStreamListFluent<T> {
    String apiVersion;
    List<VisitableBuilder<ImageStream, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ImageStreamListFluentImpl() {
    }

    public ImageStreamListFluentImpl(ImageStreamList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public T addToItems(ImageStream ... items) {
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromItems(ImageStream ... items) {
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ImageStream> getItems() {
        return this.build(this.items);
    }

    @Override
    public T withItems(List<ImageStream> items) {
        this.items.clear();
        if (items != null) {
            for (ImageStream item : items) {
                this.addToItems(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withItems(ImageStream ... items) {
        this.items.clear();
        if (items != null) {
            for (ImageStream item : items) {
                this.addToItems(item);
            }
        }
        return (T)this;
    }

    @Override
    public ImageStreamListFluent.ItemsNested<T> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ImageStreamListFluent.ItemsNested<T> addNewItemLike(ImageStream item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public ImageStreamListFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageStreamListFluent.MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageStreamListFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamListFluentImpl that = (ImageStreamListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<ImageStreamListFluent.MetadataNested<N>>
    implements ImageStreamListFluent.MetadataNested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageStreamListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends ImageStreamFluentImpl<ImageStreamListFluent.ItemsNested<N>>
    implements ImageStreamListFluent.ItemsNested<N> {
        private final ImageStreamBuilder builder;

        ItemsNestedImpl(ImageStream item) {
            this.builder = new ImageStreamBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.builder = new ImageStreamBuilder(this);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageStreamListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

