/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildConfigStatus;
import io.fabric8.openshift.api.model.BuildConfigStatusFluent;
import io.fabric8.openshift.api.model.BuildConfigStatusFluentImpl;
import io.fabric8.openshift.api.model.EditableBuildConfigStatus;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildConfigStatusBuilder
extends BuildConfigStatusFluentImpl<BuildConfigStatusBuilder>
implements VisitableBuilder<BuildConfigStatus, BuildConfigStatusBuilder> {
    BuildConfigStatusFluent<?> fluent;

    public BuildConfigStatusBuilder() {
        this(new BuildConfigStatus());
    }

    public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent) {
        this(fluent, new BuildConfigStatus());
    }

    public BuildConfigStatusBuilder(BuildConfigStatusFluent<?> fluent, BuildConfigStatus instance) {
        this.fluent = fluent;
        fluent.withLastVersion(instance.getLastVersion());
    }

    public BuildConfigStatusBuilder(BuildConfigStatus instance) {
        this.fluent = this;
        this.withLastVersion(instance.getLastVersion());
    }

    @Override
    public EditableBuildConfigStatus build() {
        EditableBuildConfigStatus buildable = new EditableBuildConfigStatus(this.fluent.getLastVersion());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigStatusBuilder that = (BuildConfigStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

