/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.environments;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.environments.Environment;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environments {
    public static final String ENVIRONMENTS_CONFIGMAP_NAME = "fabric8-environments";
    public static final String SPACE_LINK_CONFIGMAP_NAME = "fabric8-space-link";
    private static final transient Logger LOG = LoggerFactory.getLogger(Environments.class);
    private final String namespace;
    private final Map<String, Environment> environments;

    public Environments(String namespace, Map<String, Environment> environments) {
        this.namespace = namespace;
        this.environments = environments;
    }

    public static Environments load() {
        try (DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient();){
            String namespace = Environments.findSpaceNamespace((KubernetesClient)kubernetesClient);
            Environments environments = Environments.load((KubernetesClient)kubernetesClient, namespace);
            return environments;
        }
    }

    public static Environments load(String namespace) {
        try (DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient();){
            Environments environments = Environments.load((KubernetesClient)kubernetesClient, namespace);
            return environments;
        }
    }

    public static Environments load(KubernetesClient kubernetesClient, String namespace) {
        String spaceNamespace;
        namespace = Environments.getDefaultNamespace(kubernetesClient, namespace);
        LOG.debug("Loading environments from namespace: " + namespace);
        ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withName(ENVIRONMENTS_CONFIGMAP_NAME)).get();
        if (configMap == null && Strings.isNotBlank((String)(spaceNamespace = Environments.findSpaceNamespace(kubernetesClient, namespace))) && !spaceNamespace.equals(namespace)) {
            namespace = spaceNamespace;
            configMap = (ConfigMap)((Resource)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(spaceNamespace)).withName(ENVIRONMENTS_CONFIGMAP_NAME)).get();
        }
        return Environments.load(configMap, namespace);
    }

    public static String findSpaceNamespace(KubernetesClient kubernetesClient) {
        return Environments.findSpaceNamespace(kubernetesClient, KubernetesHelper.getNamespace(kubernetesClient));
    }

    public static String findSpaceNamespace(KubernetesClient kubernetesClient, String namespace) {
        try {
            String answer;
            Map data;
            ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withName(SPACE_LINK_CONFIGMAP_NAME)).get();
            if (configMap != null && (data = configMap.getData()) != null && Strings.isNotBlank((String)(answer = (String)data.get("space")))) {
                return answer;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to lookup Space Link ConfigMap " + namespace + "/" + SPACE_LINK_CONFIGMAP_NAME + ". " + e, (Throwable)e);
        }
        int idx = namespace.lastIndexOf(45);
        if (idx > 0) {
            return namespace.substring(0, idx);
        }
        return namespace;
    }

    public static String namespaceForEnvironment(String environmentKey) {
        try (DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient();){
            String namespace = KubernetesHelper.getNamespace((KubernetesClient)kubernetesClient);
            String string = Environments.namespaceForEnvironment((KubernetesClient)kubernetesClient, environmentKey, namespace);
            return string;
        }
    }

    public static String namespaceForEnvironment(String environmentKey, String namespace) {
        try (DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient();){
            String string = Environments.namespaceForEnvironment((KubernetesClient)kubernetesClient, environmentKey, namespace);
            return string;
        }
    }

    public static String namespaceForEnvironment(KubernetesClient kubernetesClient, String environmentKey, String namespace) {
        Environments environments = Environments.load(kubernetesClient, namespace);
        Environment environment = environments.getEnvironment(environmentKey);
        if (environment == null) {
            environment = environments.getEnvironment(environmentKey.toLowerCase());
        }
        String answer = null;
        if (environment != null) {
            answer = environment.getNamespace();
        }
        return answer;
    }

    protected static String getDefaultNamespace(KubernetesClient kubernetesClient, String namespace) {
        if (Strings.isNullOrBlank((String)namespace) && Strings.isNullOrBlank((String)(namespace = kubernetesClient.getNamespace()))) {
            namespace = KubernetesHelper.defaultNamespace();
        }
        return namespace;
    }

    private static Environments load(ConfigMap configMap, String namespace) {
        Map data;
        HashMap<String, Environment> environmentMap = new HashMap<String, Environment>();
        if (configMap != null && (data = configMap.getData()) != null) {
            Set entries = data.entrySet();
            for (Map.Entry entry : entries) {
                String yaml;
                String key = (String)entry.getKey();
                Environment environment = Environments.parseEnvironment(key, yaml = (String)entry.getValue());
                if (environment == null) continue;
                environmentMap.put(key, environment);
            }
        }
        return new Environments(namespace, environmentMap);
    }

    private static Environment parseEnvironment(String key, String yaml) {
        try {
            return KubernetesHelper.loadYaml(yaml, Environment.class);
        }
        catch (IOException e) {
            LOG.warn("Failed to parse environment YAML for " + key + ". Reason: " + e + ". YAML: " + yaml, (Throwable)e);
            return null;
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Environment getEnvironment(String environmentKey) {
        return this.environments.get(environmentKey);
    }

    public Map<String, Environment> getEnvironments() {
        return this.environments;
    }

    public SortedSet<Environment> getEnvironmentSet() {
        return new TreeSet<Environment>(this.environments.values());
    }
}

