/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Manifests {
    public static String getManifestEntry(File file, String attributeName) throws IOException {
        Manifest manifest = Manifests.getManifest(file);
        return Manifests.getManifestEntry(manifest, attributeName);
    }

    public static String getManifestEntry(Manifest manifest, String attributeName) throws IOException {
        if (manifest != null) {
            return manifest.getMainAttributes().getValue(attributeName);
        }
        return null;
    }

    public static Manifest getManifest(File file) throws IOException {
        try (JarFile jar = new JarFile(file);){
            Manifest manifest = jar.getManifest();
            return manifest;
        }
    }

    public static Manifest getManifestFromCurrentJar(Class<?> theClazz) throws IOException {
        String jarPath = theClazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        Manifest manifest = null;
        if (jarPath.endsWith("/")) {
            String manifestPath = jarPath + "META-INF/MANIFEST.MF";
            manifest = new Manifest(new File(manifestPath).toURI().toURL().openStream());
        } else {
            manifest = Manifests.getManifest(new File(jarPath));
        }
        return manifest;
    }

    public static Map<Attribute, String> getManifestEntryMap(Manifest manifest, Class<? extends Attribute> attributeEnum) {
        HashMap<Attribute, String> result = new HashMap<Attribute, String>();
        Attributes mainAttributes = manifest.getMainAttributes();
        for (Attribute attributeName : attributeEnum.getEnumConstants()) {
            if (mainAttributes.getValue(attributeName.value()) == null || mainAttributes.getValue(attributeName.value()).contains("${")) continue;
            result.put(attributeName, mainAttributes.getValue(attributeName.value()));
        }
        return result;
    }

    public static interface Attribute {
        public String value();
    }

    public static enum PROJECT_ATTRIBUTES implements Attribute
    {
        Title("Project-Title"),
        Description("Project-Description"),
        Version("Project-Version"),
        License("Project-License"),
        LicenseUrl("Project-LicenseUrl"),
        Contact("Project-Contact");

        public String value;

        private PROJECT_ATTRIBUTES(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

