/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class ImageEnricher
extends BaseEnricher {
    public ImageEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-image");
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        this.ensureTemplateSpecs(builder);
        this.updateContainers(builder);
    }

    private void ensureTemplateSpecs(KubernetesListBuilder builder) {
        this.ensureTemplateSpecsInReplicationControllers(builder);
        this.ensureTemplateSpecsInRelicaSet(builder);
        this.ensureTemplateSpecsInDeployments(builder);
    }

    private void ensureTemplateSpecsInReplicationControllers(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder item) {
                ReplicationControllerFluent.SpecNested spec = item.getSpec() == null ? item.withNewSpec() : item.editSpec();
                ReplicationControllerSpecFluent.TemplateNested template = spec.getTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((ReplicationControllerFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInRelicaSet(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder item) {
                ReplicaSetFluent.SpecNested spec = item.getSpec() == null ? item.withNewSpec() : item.editSpec();
                ReplicaSetSpecFluent.TemplateNested template = spec.getTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((ReplicaSetFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInDeployments(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder item) {
                DeploymentFluent.SpecNested spec = item.getSpec() == null ? item.withNewSpec() : item.editSpec();
                DeploymentSpecFluent.TemplateNested template = spec.getTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((DeploymentFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void updateContainers(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder templateBuilder) {
                PodTemplateSpecFluent.SpecNested podSpec = templateBuilder.getSpec() == null ? templateBuilder.withNewSpec() : templateBuilder.editSpec();
                ArrayList containers = podSpec.getContainers();
                if (containers == null) {
                    containers = new ArrayList();
                }
                ImageEnricher.this.mergeImageConfigurationWithContainerSpec(containers);
                ((PodTemplateSpecFluent.SpecNested)podSpec.withContainers(containers)).endSpec();
            }
        });
    }

    private void mergeImageConfigurationWithContainerSpec(List<Container> containers) {
        List images = this.getImages();
        if (images.isEmpty()) {
            this.log.warn("No resolved images!", new Object[0]);
        }
        int idx = 0;
        for (ImageConfiguration imageConfiguration : images) {
            Container container = this.getContainer(idx, containers);
            this.mergeImagePullPolicy(imageConfiguration, container);
            this.mergeImage(imageConfiguration, container);
            this.mergeContainerName(imageConfiguration, container);
            ++idx;
        }
    }

    private Container getContainer(int idx, List<Container> containers) {
        Container container;
        if (idx < containers.size()) {
            container = containers.get(idx);
        } else {
            container = new Container();
            containers.add(container);
        }
        return container;
    }

    private void mergeContainerName(ImageConfiguration imageConfiguration, Container container) {
        if (Strings.isNullOrBlank((String)container.getName())) {
            String containerName = KubernetesResourceUtil.extractContainerName((MavenProject)this.getProject(), (ImageConfiguration)imageConfiguration);
            this.log.verbose("Setting container name %s", new Object[]{containerName});
            container.setName(containerName);
        }
    }

    private void mergeImage(ImageConfiguration imageConfiguration, Container container) {
        if (Strings.isNullOrBlank((String)container.getImage())) {
            this.log.verbose("Setting image %s", new Object[]{imageConfiguration.getName()});
            container.setImage(imageConfiguration.getName());
        }
    }

    private void mergeImagePullPolicy(ImageConfiguration imageConfiguration, Container container) {
        if (Strings.isNullOrBlank((String)container.getImagePullPolicy())) {
            String policy = this.getConfig(Config.pullPolicy);
            if (policy == null) {
                policy = "IfNotPresent";
                String imageName = imageConfiguration.getName();
                if (Strings.isNotBlank((String)imageName) && imageName.endsWith(":latest")) {
                    policy = "Always";
                }
            }
            container.setImagePullPolicy(policy);
        }
    }

    private static enum Config implements Configs.Key
    {
        pullPolicy;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

