/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.enricher.api.util.GitUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class GitEnricher
extends BaseEnricher {
    public GitEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-git");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAnnotations(Kind kind) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        Repository repository = null;
        try {
            if (kind.isDeployOrReplicaKind() || kind.isService()) {
                repository = GitUtil.getGitRepository((MavenProject)this.getProject());
                if (repository != null) {
                    String id;
                    String branch = repository.getBranch();
                    if (branch != null) {
                        annotations.put("fabric8.io/git-branch", branch);
                    }
                    if ((id = GitUtil.getGitCommitId((Repository)repository)) != null) {
                        annotations.put("fabric8.io/git-commit", id);
                    }
                } else {
                    this.log.warn("No .git/config file could be found so cannot annotate kubernetes resources with git commit SHA and branch", new Object[0]);
                }
            }
            HashMap<String, String> hashMap = annotations;
            return hashMap;
        }
        catch (IOException | GitAPIException e) {
            this.log.error("Cannot extract Git information for adding to annotations: " + e, new Object[]{e});
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (repository != null) {
                try {
                    repository.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

