/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.DeploymentHandler;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicaSetHandler;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.maven.project.MavenProject;

public class DefaultControllerEnricher
extends BaseEnricher {
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig"};
    private final DeploymentHandler deployHandler;
    private final ReplicationControllerHandler rcHandler;
    private final ReplicaSetHandler rsHandler;
    private static final HashSet<Class<?>> SIMPLE_FIELD_TYPES = new HashSet();

    public DefaultControllerEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-controller");
        HandlerHub handlers = new HandlerHub(buildContext.getProject());
        this.rcHandler = handlers.getReplicationControllerHandler();
        this.rsHandler = handlers.getReplicaSetHandler();
        this.deployHandler = handlers.getDeploymentHandler();
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        final String defaultName = this.getConfig(Config.name, MavenUtil.createDefaultResourceName((MavenProject)this.getProject(), (String[])new String[0]));
        ResourceConfig config = new ResourceConfig.Builder().replicaSetName(defaultName).imagePullPolicy(this.getConfig(Config.pullPolicy)).build();
        Deployment defaultDeployment = this.deployHandler.getDeployment(config, this.getImages());
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])POD_CONTROLLER_KINDS)) {
            String type = this.getConfig(Config.type);
            if (type.equalsIgnoreCase("deployment")) {
                this.log.info("Adding a default Deployment", new Object[0]);
                builder.addToDeploymentItems(new Deployment[]{defaultDeployment});
            } else if (type.equalsIgnoreCase("replicaSet")) {
                this.log.info("Adding a default ReplicaSet", new Object[0]);
                builder.addToReplicaSetItems(new ReplicaSet[]{this.rsHandler.getReplicaSet(config, this.getImages())});
            } else if (type.equalsIgnoreCase("replicationController")) {
                this.log.info("Adding a default ReplicationController", new Object[0]);
                builder.addToReplicationControllerItems(new ReplicationController[]{this.rcHandler.getReplicationController(config, this.getImages())});
            }
        } else {
            PodSpec podSpec;
            PodTemplateSpec template;
            final DeploymentSpec spec = defaultDeployment.getSpec();
            if (spec != null && (template = spec.getTemplate()) != null && (podSpec = template.getSpec()) != null) {
                builder.accept((Visitor)new TypedVisitor<PodSpecBuilder>(){

                    public void visit(PodSpecBuilder builder) {
                        DefaultControllerEnricher.this.mergePodSpec(builder, podSpec, defaultName);
                    }
                });
                builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

                    public void visit(DeploymentBuilder builder) {
                        DeploymentSpec deploymentSpec = builder.getSpec();
                        if (deploymentSpec == null) {
                            builder.withNewSpec().endSpec();
                            deploymentSpec = builder.getSpec();
                        }
                        DefaultControllerEnricher.this.mergeDeploymentSpec(builder, spec);
                        PodTemplateSpec template = deploymentSpec.getTemplate();
                        DeploymentFluent.SpecNested specBuilder = builder.editSpec();
                        if (template == null) {
                            ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)specBuilder.withNewTemplate().withNewSpecLike(podSpec).endSpec()).endTemplate()).endSpec();
                        } else {
                            PodSpec builderSpec = template.getSpec();
                            if (builderSpec == null) {
                                ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)specBuilder.editTemplate().withNewSpecLike(podSpec).endSpec()).endTemplate()).endSpec();
                            } else {
                                PodSpecBuilder podSpecBuilder = new PodSpecBuilder(builderSpec);
                                DefaultControllerEnricher.this.mergePodSpec(podSpecBuilder, podSpec, defaultName);
                            }
                        }
                    }
                });
            }
        }
    }

    private void mergeDeploymentSpec(DeploymentBuilder builder, DeploymentSpec spec) {
        DeploymentFluent.SpecNested specBuilder = builder.editSpec();
        DefaultControllerEnricher.mergeSimpleFields(specBuilder, spec);
        specBuilder.endSpec();
    }

    private static void mergeSimpleFields(Object targetValues, Object defaultValues) {
        Class<?> tc = targetValues.getClass();
        Class<?> sc = defaultValues.getClass();
        for (Method targetGetMethod : tc.getMethods()) {
            Class<?> fieldType;
            if (!targetGetMethod.getName().startsWith("get") || !SIMPLE_FIELD_TYPES.contains(fieldType = targetGetMethod.getReturnType())) continue;
            String fieldName = targetGetMethod.getName().substring(3);
            Method withMethod = null;
            try {
                withMethod = tc.getMethod("with" + fieldName, fieldType);
            }
            catch (NoSuchMethodException e) {
                try {
                    withMethod = tc.getMethod("set" + fieldName, fieldType);
                }
                catch (NoSuchMethodException e2) {
                    continue;
                }
            }
            Method sourceGetMethod = null;
            try {
                sourceGetMethod = sc.getMethod("get" + fieldName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                if (targetGetMethod.invoke(targetValues, new Object[0]) != null) continue;
                withMethod.invoke(targetValues, sourceGetMethod.invoke(defaultValues, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    private void mergePodSpec(PodSpecBuilder builder, PodSpec defaultPodSpec, String defaultName) {
        List containers = builder.getContainers();
        List defaultContainers = defaultPodSpec.getContainers();
        int size = defaultContainers.size();
        if (size > 0) {
            if (containers == null || containers.isEmpty()) {
                builder.addToContainers(defaultContainers.toArray(new Container[size]));
            } else {
                int idx = 0;
                for (Container defaultContainer : defaultContainers) {
                    List defaultPorts;
                    Container container;
                    if (idx < containers.size()) {
                        container = (Container)containers.get(idx);
                    } else {
                        container = new Container();
                        containers.add(container);
                    }
                    DefaultControllerEnricher.mergeSimpleFields(container, defaultContainer);
                    List defaultEnv = defaultContainer.getEnv();
                    if (defaultEnv != null) {
                        for (EnvVar envVar : defaultEnv) {
                            this.ensureHasEnv(container, envVar);
                        }
                    }
                    if ((defaultPorts = defaultContainer.getPorts()) != null) {
                        for (ContainerPort port : defaultPorts) {
                            this.ensureHasPort(container, port);
                        }
                    }
                    if (container.getReadinessProbe() == null) {
                        container.setReadinessProbe(defaultContainer.getReadinessProbe());
                    }
                    if (container.getLivenessProbe() == null) {
                        container.setLivenessProbe(defaultContainer.getLivenessProbe());
                    }
                    if (container.getSecurityContext() == null) {
                        container.setSecurityContext(defaultContainer.getSecurityContext());
                    }
                    ++idx;
                }
                builder.withContainers(containers);
            }
        } else if (!containers.isEmpty()) {
            Container container = (Container)containers.get(0);
            if (Strings.isNullOrBlank((String)container.getName())) {
                container.setName(defaultName);
            }
            builder.withContainers(containers);
        }
    }

    private void ensureHasEnv(Container container, EnvVar envVar) {
        ArrayList<EnvVar> envVars = container.getEnv();
        if (envVars == null) {
            envVars = new ArrayList<EnvVar>();
            container.setEnv(envVars);
        }
        for (EnvVar var : envVars) {
            if (!Objects.equals(var.getName(), envVar.getName())) continue;
            return;
        }
        envVars.add(envVar);
    }

    private void ensureHasPort(Container container, ContainerPort port) {
        ArrayList<ContainerPort> ports = container.getPorts();
        if (ports == null) {
            ports = new ArrayList<ContainerPort>();
            container.setPorts(ports);
        }
        for (ContainerPort cp : ports) {
            String n1 = cp.getName();
            String n2 = port.getName();
            if (n1 != null && n2 != null && n1.equals(n2)) {
                return;
            }
            Integer p1 = cp.getContainerPort();
            Integer p2 = port.getContainerPort();
            if (p1 == null || p2 == null || p1.intValue() != p2.intValue()) continue;
            return;
        }
        ports.add(port);
    }

    static {
        SIMPLE_FIELD_TYPES.add(String.class);
        SIMPLE_FIELD_TYPES.add(Double.class);
        SIMPLE_FIELD_TYPES.add(Float.class);
        SIMPLE_FIELD_TYPES.add(Long.class);
        SIMPLE_FIELD_TYPES.add(Integer.class);
        SIMPLE_FIELD_TYPES.add(Short.class);
        SIMPLE_FIELD_TYPES.add(Character.class);
        SIMPLE_FIELD_TYPES.add(Byte.class);
        SIMPLE_FIELD_TYPES.add(Double.TYPE);
        SIMPLE_FIELD_TYPES.add(Float.TYPE);
        SIMPLE_FIELD_TYPES.add(Long.TYPE);
        SIMPLE_FIELD_TYPES.add(Integer.TYPE);
        SIMPLE_FIELD_TYPES.add(Short.TYPE);
        SIMPLE_FIELD_TYPES.add(Character.TYPE);
        SIMPLE_FIELD_TYPES.add(Byte.TYPE);
    }

    private static enum Config implements Configs.Key
    {
        name,
        pullPolicy{
            {
                this.d = "IfNotPresent";
            }
        }
        ,
        type{
            {
                this.d = "deployment";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

