/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.SpringBootUtil;
import io.fabric8.maven.enricher.api.AbstractHealthCheckEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import java.util.Properties;
import org.apache.maven.project.MavenProject;

public class SpringBootHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private static final String[] REQUIRED_CLASSES = new String[]{"org.springframework.boot.actuate.health.HealthIndicator", "org.springframework.web.context.support.GenericWebApplicationContext"};
    private static final int DEFAULT_SERVER_PORT = 8080;
    private static final String SCHEME_HTTPS = "HTTPS";
    private static final String SCHEME_HTTP = "HTTP";

    public SpringBootHealthCheckEnricher(EnricherContext buildContext) {
        super(buildContext, "spring-boot-health-check");
    }

    protected Probe getReadinessProbe() {
        return this.discoverSpringBootHealthCheck(10);
    }

    protected Probe getLivenessProbe() {
        return this.discoverSpringBootHealthCheck(180);
    }

    protected Probe discoverSpringBootHealthCheck(int initialDelay) {
        try {
            if (MavenUtil.hasAllClasses((MavenProject)this.getProject(), (String[])REQUIRED_CLASSES)) {
                Properties properties = SpringBootUtil.getSpringBootApplicationProperties((MavenProject)this.getProject());
                return this.buildProbe(properties, initialDelay);
            }
        }
        catch (Exception ex) {
            this.log.error("Error while reading the spring-boot configuration", new Object[]{ex});
        }
        return null;
    }

    protected Probe buildProbe(Properties springBootProperties, int initialDelay) {
        String prefix;
        String scheme;
        Integer managementPort = PropertiesHelper.getInteger((Properties)springBootProperties, (String)"management.port");
        boolean usingManagementPort = managementPort != null;
        Integer port = managementPort;
        if (port == null) {
            port = PropertiesHelper.getInteger((Properties)springBootProperties, (String)"server.port", (Integer)8080);
        }
        if (usingManagementPort) {
            scheme = Strings.isNotBlank((String)springBootProperties.getProperty("management.ssl.key-store")) ? SCHEME_HTTPS : SCHEME_HTTP;
            prefix = springBootProperties.getProperty("management.context-path", "");
        } else {
            scheme = Strings.isNotBlank((String)springBootProperties.getProperty("server.ssl.key-store")) ? SCHEME_HTTPS : SCHEME_HTTP;
            prefix = springBootProperties.getProperty("server.context-path", "");
            prefix = prefix + springBootProperties.getProperty("server.servlet-path", "");
            prefix = prefix + springBootProperties.getProperty("management.context-path", "");
        }
        return ((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(prefix + "/health")).withScheme(scheme)).endHttpGet()).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
    }
}

