/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.lifecycle;

import com.google.common.collect.Lists;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.logger.Logger;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Lifecycle {
    private static final Logger log = new Logger(Lifecycle.class);
    private final NavigableMap<Stage, CopyOnWriteArrayList<Handler>> handlers;
    private final Lock startStopLock = new ReentrantLock();
    private final AtomicReference<State> state = new AtomicReference<State>(State.NOT_STARTED);
    private Stage currStage = null;
    private final AtomicBoolean shutdownHookRegistered = new AtomicBoolean(false);

    public Lifecycle() {
        this.handlers = new TreeMap<Stage, CopyOnWriteArrayList<Handler>>();
        for (Stage stage : Stage.values()) {
            this.handlers.put(stage, new CopyOnWriteArrayList());
        }
    }

    public <T> T addManagedInstance(T o) {
        this.addHandler(new AnnotationBasedHandler(o));
        return o;
    }

    public <T> T addManagedInstance(T o, Stage stage) {
        this.addHandler(new AnnotationBasedHandler(o), stage);
        return o;
    }

    public <T> T addStartCloseInstance(T o) {
        this.addHandler(new StartCloseHandler(o));
        return o;
    }

    public <T> T addStartCloseInstance(T o, Stage stage) {
        this.addHandler(new StartCloseHandler(o), stage);
        return o;
    }

    public void addHandler(Handler handler) {
        this.addHandler(handler, Stage.NORMAL);
    }

    public void addHandler(Handler handler, Stage stage) {
        if (!this.startStopLock.tryLock()) {
            throw new ISE("Cannot add a handler in the process of Lifecycle starting or stopping", new Object[0]);
        }
        try {
            if (!this.state.get().equals((Object)State.NOT_STARTED)) {
                throw new ISE("Cannot add a handler after the Lifecycle has started, it doesn't work that way.", new Object[0]);
            }
            ((CopyOnWriteArrayList)this.handlers.get((Object)stage)).add(handler);
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    public <T> T addMaybeStartManagedInstance(T o) throws Exception {
        this.addMaybeStartHandler(new AnnotationBasedHandler(o));
        return o;
    }

    public <T> T addMaybeStartManagedInstance(T o, Stage stage) throws Exception {
        this.addMaybeStartHandler(new AnnotationBasedHandler(o), stage);
        return o;
    }

    public <T> T addMaybeStartStartCloseInstance(T o) throws Exception {
        this.addMaybeStartHandler(new StartCloseHandler(o));
        return o;
    }

    public <T> T addMaybeStartStartCloseInstance(T o, Stage stage) throws Exception {
        this.addMaybeStartHandler(new StartCloseHandler(o), stage);
        return o;
    }

    public <T extends Closeable> T addCloseableInstance(T o) {
        this.addHandler(new CloseableHandler(o));
        return o;
    }

    public void addMaybeStartHandler(Handler handler) throws Exception {
        this.addMaybeStartHandler(handler, Stage.NORMAL);
    }

    public void addMaybeStartHandler(Handler handler, Stage stage) throws Exception {
        if (!this.startStopLock.tryLock()) {
            if (this.state.get().equals((Object)State.STOP)) {
                throw new ISE("Cannot add a handler in the process of Lifecycle stopping", new Object[0]);
            }
            this.startStopLock.lock();
        }
        try {
            if (this.state.get().equals((Object)State.STOP)) {
                throw new ISE("Cannot add a handler after the Lifecycle has stopped", new Object[0]);
            }
            if (this.state.get().equals((Object)State.RUNNING) && stage.compareTo(this.currStage) <= 0) {
                handler.start();
            }
            ((CopyOnWriteArrayList)this.handlers.get((Object)stage)).add(handler);
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.startStopLock.lock();
        try {
            if (!this.state.get().equals((Object)State.NOT_STARTED)) {
                throw new ISE("Already started", new Object[0]);
            }
            if (!this.state.compareAndSet(State.NOT_STARTED, State.RUNNING)) {
                throw new ISE("stop() is called concurrently with start()", new Object[0]);
            }
            for (Map.Entry e : this.handlers.entrySet()) {
                this.currStage = (Stage)((Object)e.getKey());
                for (Handler handler : (List)e.getValue()) {
                    handler.start();
                }
            }
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.state.compareAndSet(State.RUNNING, State.STOP)) {
            log.info("Already stopped and stop was called. Silently skipping", new Object[0]);
            return;
        }
        this.startStopLock.lock();
        try {
            RuntimeException thrown = null;
            for (List stageHandlers : this.handlers.descendingMap().values()) {
                for (Handler handler : Lists.reverse((List)stageHandlers)) {
                    try {
                        handler.stop();
                    }
                    catch (RuntimeException e) {
                        log.warn(e, "exception thrown when stopping %s", handler);
                        if (thrown != null) continue;
                        thrown = e;
                    }
                }
            }
            if (thrown != null) {
                throw thrown;
            }
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    public void ensureShutdownHook() {
        if (this.shutdownHookRegistered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    log.info("Running shutdown hook", new Object[0]);
                    Lifecycle.this.stop();
                }
            }));
        }
    }

    public void join() throws InterruptedException {
        this.ensureShutdownHook();
        Thread.currentThread().join();
    }

    private static class CloseableHandler
    implements Handler {
        private static final Logger log = new Logger(CloseableHandler.class);
        private final Closeable o;

        private CloseableHandler(Closeable o) {
            this.o = o;
        }

        @Override
        public void start() throws Exception {
        }

        @Override
        public void stop() {
            log.info("Closing object[%s]", this.o);
            try {
                this.o.close();
            }
            catch (Exception e) {
                log.error(e, "Exception when closing object [%s]", this.o);
            }
        }
    }

    private static class StartCloseHandler
    implements Handler {
        private static final Logger log = new Logger(StartCloseHandler.class);
        private final Object o;
        private final Method startMethod;
        private final Method stopMethod;

        public StartCloseHandler(Object o) {
            this.o = o;
            try {
                this.startMethod = o.getClass().getMethod("start", new Class[0]);
                this.stopMethod = o.getClass().getMethod("close", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void start() throws Exception {
            log.info("Starting object[%s]", this.o);
            this.startMethod.invoke(this.o, new Object[0]);
        }

        @Override
        public void stop() {
            log.info("Stopping object[%s]", this.o);
            try {
                this.stopMethod.invoke(this.o, new Object[0]);
            }
            catch (Exception e) {
                log.error(e, "Unable to invoke stopMethod() on %s", this.o.getClass());
            }
        }
    }

    private static class AnnotationBasedHandler
    implements Handler {
        private static final Logger log = new Logger(AnnotationBasedHandler.class);
        private final Object o;

        public AnnotationBasedHandler(Object o) {
            this.o = o;
        }

        @Override
        public void start() throws Exception {
            for (Method method : this.o.getClass().getMethods()) {
                boolean doStart = false;
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().getCanonicalName().equals("io.druid.java.util.common.lifecycle.LifecycleStart") && !annotation.annotationType().getCanonicalName().equals("com.metamx.common.lifecycle.LifecycleStart")) continue;
                    doStart = true;
                    break;
                }
                if (!doStart) continue;
                log.info("Invoking start method[%s] on object[%s].", method, this.o);
                method.invoke(this.o, new Object[0]);
            }
        }

        @Override
        public void stop() {
            for (Method method : this.o.getClass().getMethods()) {
                boolean doStop = false;
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().getCanonicalName().equals("io.druid.java.util.common.lifecycle.LifecycleStop") && !annotation.annotationType().getCanonicalName().equals("com.metamx.common.lifecycle.LifecycleStop")) continue;
                    doStop = true;
                    break;
                }
                if (!doStop) continue;
                log.info("Invoking stop method[%s] on object[%s].", method, this.o);
                try {
                    method.invoke(this.o, new Object[0]);
                }
                catch (Exception e) {
                    log.error(e, "Exception when stopping method[%s] on object[%s]", method, this.o);
                }
            }
        }
    }

    public static interface Handler {
        public void start() throws Exception;

        public void stop();
    }

    private static enum State {
        NOT_STARTED,
        RUNNING,
        STOP;

    }

    public static enum Stage {
        NORMAL,
        LAST;

    }
}

