/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.IllegalFormatException;
import java.util.Locale;

public class StringUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    @Deprecated
    public static final Charset UTF8_CHARSET = Charsets.UTF_8;
    public static final String UTF8_STRING = Charsets.UTF_8.toString();

    public static int estimatedBinaryLengthAsUTF8(String value) {
        int length = 0;
        for (int i = 0; i < value.length(); ++i) {
            char var10 = value.charAt(i);
            if (var10 < '\u0080') {
                ++length;
                continue;
            }
            if (var10 < '\u0800') {
                length += 2;
                continue;
            }
            if (Character.isSurrogate(var10)) {
                length += 4;
                ++i;
                continue;
            }
            length += 3;
        }
        return length;
    }

    public static byte[] toUtf8WithNullToEmpty(String string) {
        return string == null ? EMPTY_BYTES : StringUtils.toUtf8(string);
    }

    public static String fromUtf8(byte[] bytes) {
        try {
            return new String(bytes, UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String fromUtf8(ByteBuffer buffer, int numBytes) {
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return StringUtils.fromUtf8(bytes);
    }

    public static String fromUtf8(ByteBuffer buffer) {
        return StringUtils.fromUtf8(buffer, buffer.remaining());
    }

    public static byte[] toUtf8(String string) {
        try {
            return string.getBytes(UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String format(String message, Object ... formatArgs) {
        return String.format(Locale.ENGLISH, message, formatArgs);
    }

    public static String nonStrictFormat(String message, Object ... formatArgs) {
        if (formatArgs == null || formatArgs.length == 0) {
            return message;
        }
        try {
            return String.format(Locale.ENGLISH, message, formatArgs);
        }
        catch (IllegalFormatException e) {
            StringBuilder bob = new StringBuilder(message);
            for (Object formatArg : formatArgs) {
                bob.append("; ").append(formatArg);
            }
            return bob.toString();
        }
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static String toUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }
}

