/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

public final class DateTimes {
    public static final DateTime EPOCH = DateTimes.utc(0L);
    public static final DateTime MAX = DateTimes.utc(0x3FFFFFFFFFFFFFFFL);
    public static final DateTime MIN = DateTimes.utc(-4611686018427387904L);

    public static DateTime utc(long instant) {
        return new DateTime(instant, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static DateTime of(String instant) {
        return new DateTime((Object)instant, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static DateTime nowUtc() {
        return DateTime.now((Chronology)ISOChronology.getInstanceUTC());
    }

    public static DateTime max(DateTime dt1, DateTime dt2) {
        return dt1.compareTo((ReadableInstant)dt2) >= 0 ? dt1 : dt2;
    }

    public static DateTime min(DateTime dt1, DateTime dt2) {
        return dt1.compareTo((ReadableInstant)dt2) < 0 ? dt1 : dt2;
    }

    private DateTimes() {
    }
}

