/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import io.druid.common.utils.UUIDUtils;
import io.druid.java.util.common.CompressionUtils;
import io.druid.java.util.common.IOE;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.segment.SegmentUtils;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HadoopFsWrapper;
import org.apache.hadoop.fs.Path;
import org.joda.time.format.ISODateTimeFormat;

public class HdfsDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(HdfsDataSegmentPusher.class);
    private final HdfsDataSegmentPusherConfig config;
    private final Configuration hadoopConfig;
    private final ObjectMapper jsonMapper;
    private final String fullyQualifiedStorageDirectory;

    @Inject
    public HdfsDataSegmentPusher(HdfsDataSegmentPusherConfig config, Configuration hadoopConfig, ObjectMapper jsonMapper) throws IOException {
        this.config = config;
        this.hadoopConfig = hadoopConfig;
        this.jsonMapper = jsonMapper;
        Path storageDir = new Path(config.getStorageDirectory());
        this.fullyQualifiedStorageDirectory = FileSystem.newInstance((URI)storageDir.toUri(), (Configuration)hadoopConfig).makeQualified(storageDir).toUri().toString();
        log.info("Configured HDFS as deep storage", new Object[0]);
    }

    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    public String getPathForHadoop() {
        return this.fullyQualifiedStorageDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSegment push(File inDir, DataSegment segment) throws IOException {
        DataSegment dataSegment;
        String storageDir = this.getStorageDir(segment);
        log.info("Copying segment[%s] to HDFS at location[%s/%s]", new Object[]{segment.getIdentifier(), this.fullyQualifiedStorageDirectory, storageDir});
        Path tmpIndexFile = new Path(StringUtils.format((String)"%s/%s/%s/%s_index.zip", (Object[])new Object[]{this.fullyQualifiedStorageDirectory, segment.getDataSource(), UUIDUtils.generateUuid((String[])new String[0]), segment.getShardSpec().getPartitionNum()}));
        FileSystem fs = tmpIndexFile.getFileSystem(this.hadoopConfig);
        fs.mkdirs(tmpIndexFile.getParent());
        log.info("Compressing files from[%s] to [%s]", new Object[]{inDir, tmpIndexFile});
        try (FSDataOutputStream out = fs.create(tmpIndexFile);){
            long size = CompressionUtils.zip((File)inDir, (OutputStream)out);
            Path outIndexFile = new Path(StringUtils.format((String)"%s/%s/%d_index.zip", (Object[])new Object[]{this.fullyQualifiedStorageDirectory, storageDir, segment.getShardSpec().getPartitionNum()}));
            Path outDescriptorFile = new Path(StringUtils.format((String)"%s/%s/%d_descriptor.json", (Object[])new Object[]{this.fullyQualifiedStorageDirectory, storageDir, segment.getShardSpec().getPartitionNum()}));
            dataSegment = segment.withLoadSpec(this.makeLoadSpec(outIndexFile.toUri())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir((File)inDir));
            Path tmpDescriptorFile = new Path(tmpIndexFile.getParent(), StringUtils.format((String)"%s_descriptor.json", (Object[])new Object[]{dataSegment.getShardSpec().getPartitionNum()}));
            log.info("Creating descriptor file at[%s]", new Object[]{tmpDescriptorFile});
            ByteSource.wrap((byte[])this.jsonMapper.writeValueAsBytes((Object)dataSegment)).copyTo((ByteSink)new HdfsOutputStreamSupplier(fs, tmpDescriptorFile));
            fs.mkdirs(outIndexFile.getParent());
            this.copyFilesWithChecks(fs, tmpDescriptorFile, outDescriptorFile);
            this.copyFilesWithChecks(fs, tmpIndexFile, outIndexFile);
        }
        catch (Throwable throwable) {
            try {
                if (fs.exists(tmpIndexFile.getParent()) && !fs.delete(tmpIndexFile.getParent(), true)) {
                    log.error("Failed to delete temp directory[%s]", new Object[]{tmpIndexFile.getParent()});
                }
            }
            catch (IOException ex) {
                log.error((Throwable)ex, "Failed to delete temp directory[%s]", new Object[]{tmpIndexFile.getParent()});
            }
            throw throwable;
        }
        try {
            if (fs.exists(tmpIndexFile.getParent()) && !fs.delete(tmpIndexFile.getParent(), true)) {
                log.error("Failed to delete temp directory[%s]", new Object[]{tmpIndexFile.getParent()});
            }
        }
        catch (IOException ex) {
            log.error((Throwable)ex, "Failed to delete temp directory[%s]", new Object[]{tmpIndexFile.getParent()});
        }
        return dataSegment;
    }

    private void copyFilesWithChecks(FileSystem fs, Path from, Path to) throws IOException {
        if (!HadoopFsWrapper.rename(fs, from, to)) {
            if (fs.exists(to)) {
                log.info("Unable to rename temp Index file[%s] to final segment path [%s]. It is already pushed by a replica task.", new Object[]{from, to});
            } else {
                throw new IOE("Failed to rename temp Index file[%s] and final segment path[%s] is not present.", new Object[]{from, to});
            }
        }
    }

    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)finalIndexZipFilePath.toString());
    }

    public String getStorageDir(DataSegment segment) {
        return JOINER.join((Object)segment.getDataSource(), (Object)StringUtils.format((String)"%s_%s", (Object[])new Object[]{segment.getInterval().getStart().toString(ISODateTimeFormat.basicDateTime()), segment.getInterval().getEnd().toString(ISODateTimeFormat.basicDateTime())}), new Object[]{segment.getVersion().replaceAll(":", "_")});
    }

    public String makeIndexPathName(DataSegment dataSegment, String indexName) {
        return StringUtils.format((String)"./%s/%d_%s", (Object[])new Object[]{this.getStorageDir(dataSegment), dataSegment.getShardSpec().getPartitionNum(), indexName});
    }

    private static class HdfsOutputStreamSupplier
    extends ByteSink {
        private final FileSystem fs;
        private final Path descriptorFile;

        public HdfsOutputStreamSupplier(FileSystem fs, Path descriptorFile) {
            this.fs = fs;
            this.descriptorFile = descriptorFile;
        }

        public OutputStream openStream() throws IOException {
            return this.fs.create(this.descriptorFile);
        }
    }
}

