/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.google.common.base.Supplier;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.collections.ResourceHolder;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class StupidPool<T> {
    private static final Logger log = new Logger(StupidPool.class);
    private final Supplier<T> generator;
    private final Queue<T> objects = new ConcurrentLinkedQueue<T>();
    private final int objectsCacheMaxCount;

    public StupidPool(Supplier<T> generator) {
        this.generator = generator;
        this.objectsCacheMaxCount = Integer.MAX_VALUE;
    }

    public StupidPool(Supplier<T> generator, int objectsCacheMaxCount) {
        this.generator = generator;
        this.objectsCacheMaxCount = objectsCacheMaxCount;
    }

    public ResourceHolder<T> take() {
        T obj = this.objects.poll();
        return obj == null ? new ObjectResourceHolder(this.generator.get()) : new ObjectResourceHolder(obj);
    }

    private class ObjectResourceHolder
    implements ResourceHolder<T> {
        private AtomicBoolean closed = new AtomicBoolean(false);
        private final T object;

        public ObjectResourceHolder(T object) {
            this.object = object;
        }

        @Override
        public T get() {
            if (this.closed.get()) {
                throw new ISE("Already Closed!", new Object[0]);
            }
            return this.object;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.compareAndSet(false, true)) {
                log.warn((Throwable)new ISE("Already Closed!", new Object[0]), "Already closed", new Object[0]);
                return;
            }
            if (StupidPool.this.objects.size() < StupidPool.this.objectsCacheMaxCount) {
                if (!StupidPool.this.objects.offer(this.object)) {
                    log.warn((Throwable)new ISE("Queue offer failed", new Object[0]), "Could not offer object [%s] back into the queue", new Object[]{this.object});
                }
            } else {
                log.debug("cache num entries is exceeding max limit [%s]", new Object[]{StupidPool.this.objectsCacheMaxCount});
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (!this.closed.get()) {
                    log.warn("Not closed!  Object was[%s]. Allowing gc to prevent leak.", new Object[]{this.object});
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

