/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import com.google.common.base.Strings;
import io.druid.java.util.common.logger.Logger;
import io.druid.math.expr.BinaryOpExprBase;
import io.druid.math.expr.ConstantExpr;
import io.druid.math.expr.Expr;
import java.util.Arrays;
import java.util.List;

public class Evals {
    private static final Logger log = new Logger(Evals.class);

    public static boolean isAllConstants(Expr ... exprs) {
        return Evals.isAllConstants(Arrays.asList(exprs));
    }

    public static boolean isAllConstants(List<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr instanceof ConstantExpr) continue;
            return false;
        }
        return true;
    }

    public static Expr binaryOp(BinaryOpExprBase binary, Expr left, Expr right) {
        try {
            return (Expr)binary.getClass().getDeclaredConstructor(String.class, Expr.class, Expr.class).newInstance(binary.op, left, right);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "failed to rewrite expression " + binary, new Object[0]);
            return binary;
        }
    }

    public static long asLong(boolean x) {
        return x ? 1L : 0L;
    }

    public static double asDouble(boolean x) {
        return x ? 1.0 : 0.0;
    }

    public static String asString(boolean x) {
        return String.valueOf(x);
    }

    public static boolean asBoolean(long x) {
        return x > 0L;
    }

    public static boolean asBoolean(double x) {
        return x > 0.0;
    }

    public static boolean asBoolean(String x) {
        return !Strings.isNullOrEmpty((String)x) && Boolean.valueOf(x) != false;
    }
}

