/*
 * Decompiled with CFR 0.152.
 */
package io.druid.annotations;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.druid.annotations.SubclassesMustBePublic"})
public class SubclassesMustBePublicAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : elementsAnnotatedWith) {
                if (element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, element.getSimpleName() + " must be public", element);
            }
        }
        return false;
    }
}

