/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.schemabuilder;

import com.google.common.base.Optional;
import info.archinnov.achilles.schemabuilder.SchemaStatement;

public class CreateIndex
extends SchemaStatement {
    private String indexName;
    private boolean ifNotExists = false;
    private Optional<String> keyspaceName = Optional.absent();
    private String tableName;
    private String columnName;

    CreateIndex(String indexName) {
        CreateIndex.validateNotEmpty(indexName, "Index name");
        CreateIndex.validateNotKeyWord(indexName, String.format("The index name '%s' is not allowed because it is a reserved keyword", indexName));
        this.indexName = indexName;
    }

    public CreateIndex ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    public CreateIndexOn onTable(String keyspaceName, String tableName) {
        CreateIndex.validateNotEmpty(keyspaceName, "Keyspace name");
        CreateIndex.validateNotEmpty(tableName, "Table name");
        CreateIndex.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        CreateIndex.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.keyspaceName = Optional.fromNullable((Object)keyspaceName);
        this.tableName = tableName;
        return new CreateIndexOn();
    }

    public CreateIndexOn onTable(String tableName) {
        CreateIndex.validateNotEmpty(tableName, "Table name");
        CreateIndex.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
        return new CreateIndexOn();
    }

    @Override
    String buildInternal() {
        StringBuilder createStatement = new StringBuilder("\n").append("\t").append("CREATE INDEX").append(" ");
        if (this.ifNotExists) {
            createStatement.append("IF NOT EXISTS").append(" ");
        }
        createStatement.append(this.indexName).append(" ").append("ON").append(" ");
        if (this.keyspaceName.isPresent()) {
            createStatement.append((String)this.keyspaceName.get()).append(".");
        }
        createStatement.append(this.tableName);
        return createStatement.append("(").append(this.columnName).append(")").toString();
    }

    public class CreateIndexOn {
        public String andColumn(String columnName) {
            SchemaStatement.validateNotEmpty(CreateIndex.this.tableName, "Column name");
            SchemaStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
            CreateIndex.this.columnName = columnName;
            return CreateIndex.this.buildInternal();
        }
    }
}

