/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.typed;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Statement;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.statement.StatementHelper;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.query.cql.NativeQueryValidator;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedQueryValidator {
    private static final Logger log = LoggerFactory.getLogger(TypedQueryValidator.class);
    private static String OPTIONAL_KEYSPACE_PREFIX = "[a-zA-Z0-9_]*\\.?";
    private NativeQueryValidator validator = NativeQueryValidator.Singleton.INSTANCE.get();

    public void validateTypedQuery(Class<?> entityClass, Statement statement, EntityMeta meta) {
        log.debug("Validate typed query {}", (Object)statement);
        String normalizedQueryString = StatementHelper.maybeGetNormalizedQueryString(statement);
        Validator.validateFalse(statement instanceof BatchStatement, "Cannot perform typed query with batch statements", new Object[0]);
        PropertyMeta idMeta = meta.getIdMeta();
        this.validateRawTypedQuery(entityClass, statement, meta);
        if (!normalizedQueryString.contains("select *")) {
            ImmutableList staticColumns = FluentIterable.from(meta.getAllStaticMetas()).transform(PropertyMeta.GET_CQL_COLUMN_NAME).transform(PropertyMeta.TO_LOWER_CASE).toList();
            idMeta.forTypedQuery().validateTypedQuery(normalizedQueryString, (List<String>)staticColumns);
        }
    }

    public void validateRawTypedQuery(Class<?> entityClass, Statement statement, EntityMeta meta) {
        log.debug("Validate raw typed query {}", (Object)statement);
        String queryString = StatementHelper.maybeGetQueryString(statement);
        String tableName = meta.config().getTableName().toLowerCase();
        String normalizedQuery = queryString.toLowerCase();
        this.validator.validateSelect(statement);
        Pattern pattern = Pattern.compile(".* from " + OPTIONAL_KEYSPACE_PREFIX + tableName + "(?: )?.*");
        Validator.validateTrue(pattern.matcher(normalizedQuery).matches(), "The typed query [%s] should contain the table name '%s' if type is '%s'", queryString, tableName, entityClass.getCanonicalName());
    }

    public static enum Singleton {
        INSTANCE;

        private final TypedQueryValidator instance = new TypedQueryValidator();

        public TypedQueryValidator get() {
            return this.instance;
        }
    }
}

