/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.typed;

import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.async.EntitiesWithExecutionInfo;
import info.archinnov.achilles.internal.async.RowsWithExecutionInfo;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.statement.wrapper.NativeStatementWrapper;
import info.archinnov.achilles.iterator.AchillesIterator;
import info.archinnov.achilles.listener.LWTResultListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTypedQuery<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTypedQuery.class);
    protected static final FutureCallback<Object>[] NO_CALLBACKS = new FutureCallback[0];
    protected final NativeStatementWrapper nativeStatementWrapper;
    protected DaoContext daoContext;
    protected ExecutorService executorService;
    protected Map<String, PropertyMeta> propertiesMap;
    protected EntityMeta meta;
    protected PersistenceContextFactory contextFactory;
    protected Object[] boundValues;
    protected boolean createProxy = false;
    protected Optional<PagingState> pagingStateO = Optional.absent();
    protected EntityMapper mapper = EntityMapper.Singleton.INSTANCE.get();
    protected EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();
    protected AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();

    public AbstractTypedQuery(Class<T> entityClass, DaoContext daoContext, ConfigurationContext configContext, Statement statement, EntityMeta meta, PersistenceContextFactory contextFactory, Object[] boundValues) {
        this.daoContext = daoContext;
        this.executorService = configContext.getExecutorService();
        this.boundValues = boundValues;
        this.nativeStatementWrapper = new NativeStatementWrapper(daoContext.getDriverConfig(), entityClass, statement, this.boundValues, (Optional<LWTResultListener>)Optional.absent());
        this.meta = meta;
        this.contextFactory = contextFactory;
        this.propertiesMap = this.transformPropertiesMap(meta);
    }

    protected ListenableFuture<EntitiesWithExecutionInfo<T>> asyncGetInternal(FutureCallback<Object> ... asyncListeners) {
        log.debug("Get results asynchronously for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        if (this.pagingStateO.isPresent()) {
            this.nativeStatementWrapper.setPagingState((PagingState)this.pagingStateO.get());
        }
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<RowsWithExecutionInfo> futureRows = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ROWS_WITH_EXECUTION_INFO);
        Function<RowsWithExecutionInfo, EntitiesWithExecutionInfo<T>> rowsToEntities = this.rowsToEntities();
        Function<EntitiesWithExecutionInfo<T>, EntitiesWithExecutionInfo<T>> applyTriggers = this.applyTriggersToEntities();
        Function<EntitiesWithExecutionInfo<T>, EntitiesWithExecutionInfo<T>> maybeCreateProxy = this.proxifyEntities();
        ListenableFuture<EntitiesWithExecutionInfo<T>> rawEntities = this.asyncUtils.transformFuture(futureRows, rowsToEntities);
        ListenableFuture<EntitiesWithExecutionInfo<T>> entitiesWithTriggers = this.asyncUtils.transformFuture(rawEntities, applyTriggers);
        this.asyncUtils.maybeAddAsyncListeners(entitiesWithTriggers, asyncListeners);
        ListenableFuture<EntitiesWithExecutionInfo<T>> maybeProxyCreated = this.asyncUtils.transformFuture(entitiesWithTriggers, maybeCreateProxy);
        return maybeProxyCreated;
    }

    protected AchillesFuture<T> asyncGetFirstInternal(FutureCallback<Object> ... asyncListeners) {
        log.debug("Get first result asynchronously for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<Row> futureRow = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ROW, this.executorService);
        Function<Row, T> rowToEntity = this.rowToEntity();
        Function<T, T> applyTriggers = this.applyTriggersToEntity();
        Function<T, T> maybeCreateProxy = this.proxifyEntity();
        ListenableFuture<T> rawEntity = this.asyncUtils.transformFuture(futureRow, rowToEntity);
        ListenableFuture<T> entityWithTriggers = this.asyncUtils.transformFuture(rawEntity, applyTriggers);
        this.asyncUtils.maybeAddAsyncListeners(entityWithTriggers, asyncListeners);
        ListenableFuture<T> maybeProxyCreated = this.asyncUtils.transformFuture(entityWithTriggers, maybeCreateProxy);
        return this.asyncUtils.buildInterruptible(maybeProxyCreated);
    }

    protected AchillesFuture<Iterator<T>> asyncIteratorInternal(Optional<Integer> fetchSizeO, FutureCallback<Object> ... asyncListeners) {
        Statement statement = this.nativeStatementWrapper.getStatement();
        log.debug("Get iterator asynchronously for typed query '{}'", (Object)statement.toString());
        if (fetchSizeO.isPresent()) {
            statement.setFetchSize(((Integer)fetchSizeO.get()).intValue());
        }
        final PersistenceContext persistenceContext = this.contextFactory.newContextForTypedQuery(this.meta.getEntityClass());
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<Iterator<Row>> futureIterator = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ITERATOR, this.executorService);
        Function rowToIterator = new Function<Iterator<Row>, Iterator<T>>(){

            public Iterator<T> apply(Iterator<Row> rowIterator) {
                return new AchillesIterator(AbstractTypedQuery.this.meta, AbstractTypedQuery.this.createProxy, persistenceContext, rowIterator);
            }
        };
        ListenableFuture listenableFuture = this.asyncUtils.transformFuture(futureIterator, rowToIterator);
        this.asyncUtils.maybeAddAsyncListeners(listenableFuture, asyncListeners);
        return this.asyncUtils.buildInterruptible(listenableFuture);
    }

    protected Function<Row, T> rowToEntity() {
        return new Function<Row, T>(){

            public T apply(Row row) {
                Object entity = null;
                if (row != null) {
                    entity = AbstractTypedQuery.this.mapper.mapRowToEntityWithPrimaryKey(AbstractTypedQuery.this.meta, row, AbstractTypedQuery.this.propertiesMap, AbstractTypedQuery.this.createProxy ? EntityMeta.EntityState.MANAGED : EntityMeta.EntityState.NOT_MANAGED);
                }
                return entity;
            }
        };
    }

    protected Function<T, T> applyTriggersToEntity() {
        return new Function<T, T>(){

            public T apply(T entity) {
                if (entity != null) {
                    AbstractTypedQuery.this.meta.forInterception().intercept(entity, Event.POST_LOAD);
                }
                return entity;
            }
        };
    }

    protected Function<T, T> proxifyEntity() {
        return new Function<T, T>(){

            public T apply(T entity) {
                Object newEntity = entity;
                if (entity != null && AbstractTypedQuery.this.createProxy) {
                    newEntity = AbstractTypedQuery.this.buildProxy(entity);
                }
                return newEntity;
            }
        };
    }

    protected Function<RowsWithExecutionInfo, EntitiesWithExecutionInfo<T>> rowsToEntities() {
        return new Function<RowsWithExecutionInfo, EntitiesWithExecutionInfo<T>>(){

            public EntitiesWithExecutionInfo<T> apply(RowsWithExecutionInfo rows) {
                ArrayList<Object> entities = new ArrayList<Object>();
                for (Row row : rows.getRows()) {
                    entities.add(AbstractTypedQuery.this.rowToEntity().apply((Object)row));
                }
                return new EntitiesWithExecutionInfo(FluentIterable.from(entities).filter(Predicates.notNull()).toList(), rows.getExecutionInfo());
            }
        };
    }

    protected Function<EntitiesWithExecutionInfo<T>, EntitiesWithExecutionInfo<T>> applyTriggersToEntities() {
        return new Function<EntitiesWithExecutionInfo<T>, EntitiesWithExecutionInfo<T>>(){

            public EntitiesWithExecutionInfo<T> apply(EntitiesWithExecutionInfo<T> entities) {
                for (Object entity : entities.getEntities()) {
                    AbstractTypedQuery.this.applyTriggersToEntity().apply(entity);
                }
                return entities;
            }
        };
    }

    protected Function<EntitiesWithExecutionInfo<T>, EntitiesWithExecutionInfo<T>> proxifyEntities() {
        return new Function<EntitiesWithExecutionInfo<T>, EntitiesWithExecutionInfo<T>>(){

            public EntitiesWithExecutionInfo<T> apply(EntitiesWithExecutionInfo<T> entities) {
                if (AbstractTypedQuery.this.createProxy) {
                    ArrayList<Object> proxies = new ArrayList<Object>();
                    for (Object entity : entities.getEntities()) {
                        proxies.add(AbstractTypedQuery.this.proxifyEntity().apply(entity));
                    }
                    return new EntitiesWithExecutionInfo(FluentIterable.from(proxies).filter(Predicates.notNull()).toList(), entities.getExecutionInfo());
                }
                return entities;
            }
        };
    }

    private Map<String, PropertyMeta> transformPropertiesMap(EntityMeta meta) {
        HashMap<String, PropertyMeta> propertiesMap = new HashMap<String, PropertyMeta>();
        for (PropertyMeta pm : meta.getPropertyMetas().values()) {
            if (pm.type().isCompoundPK()) continue;
            String cqlColumnName = pm.getCQLColumnName().replaceAll("\"", "");
            propertiesMap.put(cqlColumnName, pm);
        }
        return propertiesMap;
    }

    private T buildProxy(T entity) {
        PersistenceContext context = this.contextFactory.newContext(entity);
        entity = this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(entity, context.getEntityFacade());
        return entity;
    }
}

