/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.slice;

import com.google.common.util.concurrent.FutureCallback;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.SliceQueryExecutor;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.query.slice.SliceQueryProperties;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Empty;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SliceQueryRoot<TYPE, T extends SliceQueryRoot<TYPE, T>> {
    private static final Logger log = LoggerFactory.getLogger(SliceQueryRoot.class);
    protected final SliceQueryExecutor sliceQueryExecutor;
    protected final Class<TYPE> entityClass;
    protected final EntityMeta meta;
    protected final SliceQueryProperties<TYPE> properties;

    protected SliceQueryRoot(SliceQueryExecutor sliceQueryExecutor, Class<TYPE> entityClass, EntityMeta meta, SliceQueryProperties.SliceType sliceType) {
        this.sliceQueryExecutor = sliceQueryExecutor;
        this.entityClass = entityClass;
        this.meta = meta;
        this.properties = SliceQueryProperties.builder(meta, entityClass, sliceType);
    }

    protected void withPartitionComponentsInternal(Object ... partitionKeyComponents) {
        log.trace("Add partition key components {}", partitionKeyComponents);
        Validator.validateNotEmpty(partitionKeyComponents, "Partition key components should not be empty", new Object[0]);
        this.meta.forSliceQuery().validatePartitionComponents(partitionKeyComponents);
        this.properties.partitionKeys(Arrays.asList(partitionKeyComponents));
        this.properties.partitionKeysName(this.meta.forSliceQuery().getPartitionKeysName(partitionKeyComponents.length));
    }

    protected void withPartitionComponentsINInternal(Object ... partitionKeyComponentsIn) {
        log.trace("Add partition key components for IN clause {}", partitionKeyComponentsIn);
        this.meta.forSliceQuery().validatePartitionComponentsIn(partitionKeyComponentsIn);
        this.properties.andPartitionKeysIn(Arrays.asList(partitionKeyComponentsIn));
        this.properties.lastPartitionKeyName(this.meta.forSliceQuery().getLastPartitionKeyName());
    }

    protected void andPartitionKeysINInternal(Object ... partitionKeyComponentsIn) {
        log.trace("Add partition key components for IN clause {}", partitionKeyComponentsIn);
        List<Object> partitionKeys = this.properties.getPartitionKeys();
        int correctPartitionKeysSize = this.meta.forSliceQuery().getPartitionKeysSize() - 1;
        Validator.validateNotEmpty(partitionKeys, "Before adding partition key components for IN clause, you should define first partition key components for query using withPartitionKeys(Object... partitionKeyComponentsIn)", new Object[0]);
        Validator.validateNotEmpty(partitionKeyComponentsIn, "Partition key components for IN clause should not be empty", new Object[0]);
        Validator.validateTrue(partitionKeys.size() == correctPartitionKeysSize, "To use the IN clause, you must provide '%s' partition keys components first", correctPartitionKeysSize);
        this.meta.forSliceQuery().validatePartitionComponentsIn(partitionKeyComponentsIn);
        this.properties.andPartitionKeysIn(Arrays.asList(partitionKeyComponentsIn));
        this.properties.lastPartitionKeyName(this.meta.forSliceQuery().getLastPartitionKeyName());
    }

    protected void fromClusteringsInternal(Object ... clusteringKeys) {
        log.trace("Add from clustering components {}", clusteringKeys);
        Validator.validateNotEmpty(clusteringKeys, "Clustering key components should not be empty", new Object[0]);
        this.meta.forSliceQuery().validateClusteringComponents(clusteringKeys);
        this.properties.fromClusteringKeys(Arrays.asList(clusteringKeys));
        this.properties.fromClusteringKeysName(this.meta.forSliceQuery().getClusteringKeysName(clusteringKeys.length));
    }

    protected void toClusteringsInternal(Object ... clusteringKeys) {
        log.trace("Add to clustering components {}", clusteringKeys);
        Validator.validateNotEmpty(clusteringKeys, "Clustering key components should not be empty", new Object[0]);
        this.meta.forSliceQuery().validateClusteringComponents(clusteringKeys);
        this.properties.toClusteringKeys(Arrays.asList(clusteringKeys));
        this.properties.toClusteringKeysName(this.meta.forSliceQuery().getClusteringKeysName(clusteringKeys.length));
    }

    protected void withClusteringsInternal(Object ... clusteringKeys) {
        Validator.validateNotEmpty(clusteringKeys, "Clustering key components should not be empty", new Object[0]);
        this.meta.forSliceQuery().validateClusteringComponents(clusteringKeys);
        this.properties.withClusteringKeys(Arrays.asList(clusteringKeys));
        this.properties.withClusteringKeysName(this.meta.forSliceQuery().getClusteringKeysName(clusteringKeys.length));
    }

    protected void andClusteringsInInternal(Object ... clusteringKeys) {
        List<Object> withClusteringKeys = this.properties.getWithClusteringKeys();
        int correctWithClusteringKeysSize = this.meta.forSliceQuery().getClusteringKeysSize() - 1;
        Validator.validateNotEmpty(withClusteringKeys, "Before adding clustering key components for IN clause, you should define first clustering key components for query using withClusteringKeys(Object... partitionKeys)", new Object[0]);
        Validator.validateNotEmpty(clusteringKeys, "Clustering key components for IN clause should not be empty", new Object[0]);
        Validator.validateTrue(withClusteringKeys.size() == correctWithClusteringKeysSize, "To use the IN clause, you must provide '%s' clustering keys components first", correctWithClusteringKeysSize);
        this.meta.forSliceQuery().validateClusteringComponentsIn(clusteringKeys);
        this.properties.andClusteringKeysIn(Arrays.asList(clusteringKeys));
        this.properties.lastClusteringKeyName(this.meta.forSliceQuery().getLastClusteringKeyName());
    }

    public T withConsistency(ConsistencyLevel consistencyLevel) {
        this.properties.readConsistency(consistencyLevel);
        return this.getThis();
    }

    public T withAsyncListeners(FutureCallback<Object> ... asyncListeners) {
        this.properties.asyncListeners(asyncListeners);
        return this.getThis();
    }

    public T withProxy() {
        this.properties.createProxy();
        return this.getThis();
    }

    protected abstract T getThis();

    protected List<TYPE> getInternal() {
        return this.sliceQueryExecutor.get(this.properties);
    }

    protected AchillesFuture<List<TYPE>> asyncGetInternal() {
        return this.sliceQueryExecutor.asyncGet(this.properties);
    }

    protected AchillesFuture<TYPE> asyncGetOneInternal() {
        return this.sliceQueryExecutor.asyncGetOne(this.properties);
    }

    protected Iterator<TYPE> iteratorInternal() {
        return this.sliceQueryExecutor.iterator(this.properties);
    }

    protected AchillesFuture<Iterator<TYPE>> asyncIteratorInternal() {
        return this.sliceQueryExecutor.asyncIterator(this.properties);
    }

    protected void deleteInternal() {
        this.sliceQueryExecutor.delete(this.properties);
    }

    protected AchillesFuture<Empty> asyncDeleteInternal() {
        return this.sliceQueryExecutor.asyncDelete(this.properties);
    }
}

