/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.cql;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.persistence.operations.TypedMapIterator;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.query.cql.AbstractNativeQuery;
import info.archinnov.achilles.query.cql.TypedMapsWithPagingState;
import info.archinnov.achilles.type.TypedMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeQuery
extends AbstractNativeQuery<NativeQuery> {
    private static final Logger log = LoggerFactory.getLogger(NativeQuery.class);

    public NativeQuery(DaoContext daoContext, ConfigurationContext configContext, Statement statement, Options options, Object ... boundValues) {
        super(daoContext, configContext, statement, options, boundValues);
    }

    @Override
    protected NativeQuery getThis() {
        return this;
    }

    public List<TypedMap> get() {
        log.debug("Get results for native query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncUtils.buildInterruptible(this.asyncGetInternal(new FutureCallback[0])).getImmediately().getTypedMaps();
    }

    public TypedMapsWithPagingState getWithPagingState() {
        log.debug("Get results for native query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncUtils.buildInterruptible(this.asyncGetInternal(new FutureCallback[0])).getImmediately();
    }

    public TypedMap getFirst() {
        log.debug("Get first result for native query {}", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncGetFirstInternal(new FutureCallback[0]).getImmediately();
    }

    public void execute() {
        log.debug("Execute native query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        this.asyncExecuteInternal(new FutureCallback[0]).getImmediately();
    }

    public Iterator<TypedMap> iterator() {
        log.debug("Execute native query {} and return iterator", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> future = this.daoContext.execute(this.nativeStatementWrapper);
        return new TypedMapIterator(this.asyncUtils.buildInterruptible(future).getImmediately().iterator());
    }

    public Iterator<TypedMap> iterator(int fetchSize) {
        Statement statement = this.nativeStatementWrapper.getStatement();
        log.debug("Execute native query {} and return iterator", (Object)statement);
        statement.setFetchSize(fetchSize);
        ListenableFuture<ResultSet> future = this.daoContext.execute(this.nativeStatementWrapper);
        return new TypedMapIterator(this.asyncUtils.buildInterruptible(future).getImmediately().iterator());
    }
}

