/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.cql;

import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.query.cql.AbstractNativeQuery;
import info.archinnov.achilles.query.cql.TypedMapsWithPagingState;
import info.archinnov.achilles.type.Empty;
import info.archinnov.achilles.type.TypedMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNativeQuery
extends AbstractNativeQuery<AsyncNativeQuery> {
    private static final Logger log = LoggerFactory.getLogger(AsyncNativeQuery.class);

    public AsyncNativeQuery(DaoContext daoContext, ConfigurationContext configContext, Statement statement, Options options, Object ... boundValues) {
        super(daoContext, configContext, statement, options, boundValues);
    }

    @Override
    protected AsyncNativeQuery getThis() {
        return this;
    }

    public AchillesFuture<List<TypedMap>> get(FutureCallback<Object> ... asyncListeners) {
        ListenableFuture<TypedMapsWithPagingState> typedMapsWithPagingFutures = super.asyncGetInternal(asyncListeners);
        ListenableFuture<List<TypedMap>> typedMapsFuture = this.asyncUtils.transformFuture(typedMapsWithPagingFutures, new Function<TypedMapsWithPagingState, List<TypedMap>>(){

            @Nullable
            public List<TypedMap> apply(TypedMapsWithPagingState input) {
                return input.getTypedMaps();
            }
        });
        return this.asyncUtils.buildInterruptible(typedMapsFuture);
    }

    public AchillesFuture<TypedMapsWithPagingState> getWithPagingState(FutureCallback<Object> ... asyncListeners) {
        ListenableFuture<TypedMapsWithPagingState> typedMapsWithPagingFutures = super.asyncGetInternal(asyncListeners);
        return this.asyncUtils.buildInterruptible(typedMapsWithPagingFutures);
    }

    public AchillesFuture<TypedMap> getFirst(FutureCallback<Object> ... asyncListeners) {
        return super.asyncGetFirstInternal(asyncListeners);
    }

    public AchillesFuture<Empty> execute(FutureCallback<Object> ... asyncListeners) {
        return super.asyncExecuteInternal(asyncListeners);
    }

    public AchillesFuture<Iterator<TypedMap>> iterator(FutureCallback<Object> ... asyncListeners) {
        return super.asyncIterator((Optional<Integer>)Optional.absent(), asyncListeners);
    }

    public AchillesFuture<Iterator<TypedMap>> iterator(int fetchSize, FutureCallback<Object> ... asyncListeners) {
        return super.asyncIterator((Optional<Integer>)Optional.fromNullable((Object)fetchSize), asyncListeners);
    }
}

