/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.cql;

import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.async.RowsWithExecutionInfo;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.persistence.operations.NativeQueryMapper;
import info.archinnov.achilles.internal.persistence.operations.TypedMapIterator;
import info.archinnov.achilles.internal.statement.wrapper.NativeQueryLog;
import info.archinnov.achilles.internal.statement.wrapper.NativeStatementWrapper;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.query.cql.TypedMapsWithPagingState;
import info.archinnov.achilles.type.Empty;
import info.archinnov.achilles.type.TypedMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNativeQuery<T extends AbstractNativeQuery<T>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractNativeQuery.class);
    protected NativeStatementWrapper nativeStatementWrapper;
    protected DaoContext daoContext;
    protected AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();
    protected NativeQueryMapper mapper = NativeQueryMapper.Singleton.INSTANCE.get();
    protected Optional<PagingState> pagingStateO = Optional.absent();
    protected ExecutorService executorService;

    protected AbstractNativeQuery(DaoContext daoContext, ConfigurationContext configContext, Statement statement, Options options, Object ... boundValues) {
        this.daoContext = daoContext;
        this.nativeStatementWrapper = new NativeStatementWrapper(daoContext.getDriverConfig(), NativeQueryLog.class, statement, boundValues, options.getLWTResultListener());
        this.executorService = configContext.getExecutorService();
    }

    protected abstract T getThis();

    protected ListenableFuture<TypedMapsWithPagingState> asyncGetInternal(FutureCallback<Object> ... asyncListeners) {
        log.debug("Get results for native query '{}' asynchronously", (Object)this.nativeStatementWrapper.getStatement());
        if (this.pagingStateO.isPresent()) {
            this.nativeStatementWrapper.setPagingState((PagingState)this.pagingStateO.get());
        }
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<RowsWithExecutionInfo> futureRows = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ROWS_WITH_EXECUTION_INFO);
        Function<RowsWithExecutionInfo, TypedMapsWithPagingState> rowsToTypedMaps = new Function<RowsWithExecutionInfo, TypedMapsWithPagingState>(){

            public TypedMapsWithPagingState apply(RowsWithExecutionInfo rows) {
                List<TypedMap> typedMaps = AbstractNativeQuery.this.mapper.mapRows(rows.getRows());
                return new TypedMapsWithPagingState(typedMaps, rows.getExecutionInfo().getPagingState());
            }
        };
        ListenableFuture<TypedMapsWithPagingState> futureTypedMap = this.asyncUtils.transformFuture(futureRows, rowsToTypedMaps);
        this.asyncUtils.maybeAddAsyncListeners(futureTypedMap, asyncListeners);
        return futureTypedMap;
    }

    protected AchillesFuture<TypedMap> asyncGetFirstInternal(FutureCallback<Object> ... asyncListeners) {
        log.debug("Get first result for native query '{}' asynchronously", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<List<Row>> futureRows = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ROWS);
        Function<List<Row>, TypedMap> rowsToTypedMap = new Function<List<Row>, TypedMap>(){

            public TypedMap apply(List<Row> rows) {
                List<TypedMap> result = AbstractNativeQuery.this.mapper.mapRows(rows);
                if (result.isEmpty()) {
                    return null;
                }
                return result.get(0);
            }
        };
        ListenableFuture<TypedMap> futureTypedMap = this.asyncUtils.transformFuture(futureRows, rowsToTypedMap);
        this.asyncUtils.maybeAddAsyncListeners(futureTypedMap, asyncListeners);
        return this.asyncUtils.buildInterruptible(futureTypedMap);
    }

    protected AchillesFuture<Empty> asyncExecuteInternal(FutureCallback<Object> ... asyncListeners) {
        log.debug("Execute native query '{}' asynchronously", (Object)this.nativeStatementWrapper.getStatement());
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(this.nativeStatementWrapper);
        ListenableFuture<Empty> futureEmpty = this.asyncUtils.transformFutureToEmpty(resultSetFuture, this.executorService);
        this.asyncUtils.maybeAddAsyncListeners(futureEmpty, asyncListeners);
        return this.asyncUtils.buildInterruptible(futureEmpty);
    }

    protected AchillesFuture<Iterator<TypedMap>> asyncIterator(Optional<Integer> fetchSizeO, FutureCallback<Object> ... asyncListeners) {
        Statement statement = this.nativeStatementWrapper.getStatement();
        log.debug("Execute native query {} and return iterator", (Object)statement);
        if (fetchSizeO.isPresent()) {
            statement.setFetchSize(((Integer)fetchSizeO.get()).intValue());
        }
        ListenableFuture<ResultSet> futureResultSet = this.daoContext.execute(this.nativeStatementWrapper);
        Function<ResultSet, Iterator<TypedMap>> toTypedMap = new Function<ResultSet, Iterator<TypedMap>>(){

            public Iterator<TypedMap> apply(ResultSet resultSet) {
                return new TypedMapIterator(resultSet.iterator());
            }
        };
        ListenableFuture<Iterator<TypedMap>> futureTypedMapIterator = this.asyncUtils.transformFuture(futureResultSet, toTypedMap, this.executorService);
        this.asyncUtils.maybeAddAsyncListeners(futureTypedMapIterator, asyncListeners);
        return this.asyncUtils.buildInterruptible(futureTypedMapIterator);
    }

    public T withPagingState(PagingState pagingState) {
        this.pagingStateO = Optional.fromNullable((Object)pagingState);
        return this.getThis();
    }

    public T withPagingState(String pagingState) {
        this.pagingStateO = Optional.fromNullable((Object)PagingState.fromString((String)pagingState));
        return this.getThis();
    }

    public T withPagingState(byte[] pagingState) {
        this.pagingStateO = Optional.fromNullable((Object)PagingState.fromBytes((byte[])pagingState));
        return this.getThis();
    }
}

