/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.options;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.listener.LWTResultListener;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.type.ConsistencyLevel;
import java.util.Arrays;
import java.util.List;

public class OptionsBuilder {
    private static final NoOptions NO_OPTIONS = new NoOptions();
    private static final Options.LWTIfExists IF_EXISTS = Options.LWTIfExists.Singleton.INSTANCE.get();
    private static final Options.LWTIfNotExists IF_NOT_EXISTS = Options.LWTIfNotExists.Singleton.INSTANCE.get();

    public static NoOptions noOptions() {
        return NO_OPTIONS;
    }

    public static BuiltOptions withConsistency(ConsistencyLevel consistencyLevel) {
        return new BuiltOptions(consistencyLevel);
    }

    static BuiltOptions withConsistencyO(Optional<ConsistencyLevel> consistencyLevelO) {
        return new BuiltOptions(consistencyLevelO, true);
    }

    public static BuiltOptions withTtl(Integer ttl) {
        return new BuiltOptions(ttl);
    }

    public static BuiltOptions withTimestamp(Long timestamp) {
        return new BuiltOptions(timestamp);
    }

    public static BuiltOptions ifNotExists() {
        return new BuiltOptions(IF_NOT_EXISTS);
    }

    public static BuiltOptions ifExists() {
        return new BuiltOptions(IF_EXISTS);
    }

    @Deprecated
    public static BuiltOptions ifConditions(Options.LWTCondition ... lwtConditions) {
        return new BuiltOptions(lwtConditions);
    }

    public static BuiltOptions ifEqualCondition(String columnName, Object value) {
        return new BuiltOptions(new Options.LWTCondition(Options.LWTPredicate.LWTType.EQUAL_CONDITION, columnName, value));
    }

    public static BuiltOptions ifNotEqualCondition(String columnName, Object value) {
        return new BuiltOptions(new Options.LWTCondition(Options.LWTPredicate.LWTType.NOT_EQUAL_CONDITION, columnName, value));
    }

    public static BuiltOptions ifGreaterCondition(String columnName, Object value) {
        return new BuiltOptions(new Options.LWTCondition(Options.LWTPredicate.LWTType.GT_CONDITION, columnName, value));
    }

    public static BuiltOptions ifGreaterOrEqualCondition(String columnName, Object value) {
        return new BuiltOptions(new Options.LWTCondition(Options.LWTPredicate.LWTType.GTE_CONDITION, columnName, value));
    }

    public static BuiltOptions ifLesserCondition(String columnName, Object value) {
        return new BuiltOptions(new Options.LWTCondition(Options.LWTPredicate.LWTType.LT_CONDITION, columnName, value));
    }

    public static BuiltOptions ifLesserOrEqualCondition(String columnName, Object value) {
        return new BuiltOptions(new Options.LWTCondition(Options.LWTPredicate.LWTType.LTE_CONDITION, columnName, value));
    }

    public static BuiltOptions lwtResultListener(LWTResultListener listener) {
        return new BuiltOptions(listener);
    }

    public static BuiltOptions withAsyncListeners(FutureCallback<Object> ... listeners) {
        return new BuiltOptions(listeners);
    }

    public static BuiltOptions lwtLocalSerial() {
        return new BuiltOptions((Optional<com.datastax.driver.core.ConsistencyLevel>)Optional.fromNullable((Object)com.datastax.driver.core.ConsistencyLevel.LOCAL_SERIAL));
    }

    public static BuiltOptions withProxy() {
        return new BuiltOptions(true);
    }

    public static class BuiltOptions
    extends Options {
        protected BuiltOptions(ConsistencyLevel consistencyLevel) {
            this.consistency = Optional.fromNullable((Object)consistencyLevel);
        }

        protected BuiltOptions(Optional<ConsistencyLevel> consistencyLevelO, boolean flag) {
            this.consistency = consistencyLevelO;
        }

        protected BuiltOptions(Integer ttl) {
            this.ttl = Optional.fromNullable((Object)ttl);
        }

        protected BuiltOptions(Long timestamp) {
            this.timestamp = Optional.fromNullable((Object)timestamp);
        }

        protected BuiltOptions(Options.LWTPredicate ... lwtPredicates) {
            this.lwtPredicates.addAll(Arrays.asList(lwtPredicates));
        }

        protected BuiltOptions(LWTResultListener listener) {
            this.lwtResultListenerO = Optional.fromNullable((Object)listener);
        }

        protected BuiltOptions(Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyO) {
            this.serialConsistencyO = serialConsistencyO;
        }

        protected BuiltOptions(FutureCallback<Object> ... listeners) {
            this.asyncListeners = Arrays.asList(listeners);
        }

        protected BuiltOptions(boolean createProxy) {
            this.createProxy = createProxy;
        }

        public BuiltOptions withConsistency(ConsistencyLevel consistencyLevel) {
            this.consistency = Optional.fromNullable((Object)consistencyLevel);
            return this;
        }

        public BuiltOptions withTtl(Integer ttl) {
            this.ttl = Optional.fromNullable((Object)ttl);
            return this;
        }

        BuiltOptions withTtlO(Optional<Integer> ttlO) {
            this.ttl = ttlO;
            return this;
        }

        public BuiltOptions withTimestamp(Long timestamp) {
            this.timestamp = Optional.fromNullable((Object)timestamp);
            return this;
        }

        BuiltOptions withTimestampO(Optional<Long> timestampO) {
            this.timestamp = timestampO;
            return this;
        }

        public BuiltOptions ifNotExists() {
            Validator.validateEmpty(this.lwtPredicates, "There is already existing Lightweight Transaction predicate : '%s', cannot add IF NOT EXISTS", this.lwtPredicates.toString());
            this.lwtPredicates.add(IF_NOT_EXISTS);
            return this;
        }

        public BuiltOptions ifNotExists(boolean ifNotExists) {
            if (ifNotExists) {
                Validator.validateEmpty(this.lwtPredicates, "There is already existing Lightweight Transaction predicate : '%s', cannot add IF NOT EXISTS", this.lwtPredicates.toString());
                this.lwtPredicates.add(IF_NOT_EXISTS);
            }
            return this;
        }

        public BuiltOptions ifExists() {
            Validator.validateEmpty(this.lwtPredicates, "There is already existing Lightweight Transaction predicate : '%s', cannot add IF EXISTS", this.lwtPredicates.toString());
            this.lwtPredicates.add(IF_EXISTS);
            return this;
        }

        public BuiltOptions ifExists(boolean ifExists) {
            if (ifExists) {
                Validator.validateEmpty(this.lwtPredicates, "There is already existing Lightweight Transaction predicate : '%s', cannot add IF EXISTS", this.lwtPredicates.toString());
                this.lwtPredicates.add(IF_EXISTS);
            }
            return this;
        }

        @Deprecated
        public BuiltOptions LWTResultListener(LWTResultListener listener) {
            return this.lwtResultListener(listener);
        }

        public BuiltOptions lwtResultListener(LWTResultListener listener) {
            this.lwtResultListenerO = Optional.fromNullable((Object)listener);
            return this;
        }

        @Deprecated
        public BuiltOptions ifConditions(Options.LWTCondition ... lwtConditions) {
            Validator.validateFalse(this.lwtPredicates.contains(IF_EXISTS), "Cannot add IF = XXX with IF EXISTS", new Object[0]);
            Validator.validateFalse(this.lwtPredicates.contains(IF_NOT_EXISTS), "Cannot add IF = XXX with IF NOT EXISTS", new Object[0]);
            this.lwtPredicates.addAll(Arrays.asList(lwtConditions));
            return this;
        }

        @Deprecated
        public BuiltOptions ifConditions(List<Options.LWTCondition> lwtConditions) {
            this.lwtPredicates.addAll(lwtConditions);
            return this;
        }

        public BuiltOptions ifEqualCondition(String columnName, Object value) {
            Validator.validateFalse(this.lwtPredicates.contains(IF_EXISTS), "Cannot add IF = XXX with IF EXISTS", new Object[0]);
            Validator.validateFalse(this.lwtPredicates.contains(IF_NOT_EXISTS), "Cannot add IF = XXX with IF NOT EXISTS", new Object[0]);
            this.lwtPredicates.add(new Options.LWTCondition(Options.LWTPredicate.LWTType.EQUAL_CONDITION, columnName, value));
            return this;
        }

        public BuiltOptions ifNotEqualCondition(String columnName, Object value) {
            Validator.validateFalse(this.lwtPredicates.contains(IF_EXISTS), "Cannot add IF = XXX with IF EXISTS", new Object[0]);
            Validator.validateFalse(this.lwtPredicates.contains(IF_NOT_EXISTS), "Cannot add IF = XXX with IF NOT EXISTS", new Object[0]);
            this.lwtPredicates.add(new Options.LWTCondition(Options.LWTPredicate.LWTType.NOT_EQUAL_CONDITION, columnName, value));
            return this;
        }

        public BuiltOptions ifGreaterCondition(String columnName, Object value) {
            Validator.validateFalse(this.lwtPredicates.contains(IF_EXISTS), "Cannot add IF = XXX with IF EXISTS", new Object[0]);
            Validator.validateFalse(this.lwtPredicates.contains(IF_NOT_EXISTS), "Cannot add IF = XXX with IF NOT EXISTS", new Object[0]);
            this.lwtPredicates.add(new Options.LWTCondition(Options.LWTPredicate.LWTType.GT_CONDITION, columnName, value));
            return this;
        }

        public BuiltOptions ifGreaterOrEqualCondition(String columnName, Object value) {
            Validator.validateFalse(this.lwtPredicates.contains(IF_EXISTS), "Cannot add IF = XXX with IF EXISTS", new Object[0]);
            Validator.validateFalse(this.lwtPredicates.contains(IF_NOT_EXISTS), "Cannot add IF = XXX with IF NOT EXISTS", new Object[0]);
            this.lwtPredicates.add(new Options.LWTCondition(Options.LWTPredicate.LWTType.GTE_CONDITION, columnName, value));
            return this;
        }

        public BuiltOptions ifLesserCondition(String columnName, Object value) {
            Validator.validateFalse(this.lwtPredicates.contains(IF_EXISTS), "Cannot add IF = XXX with IF EXISTS", new Object[0]);
            Validator.validateFalse(this.lwtPredicates.contains(IF_NOT_EXISTS), "Cannot add IF = XXX with IF NOT EXISTS", new Object[0]);
            this.lwtPredicates.add(new Options.LWTCondition(Options.LWTPredicate.LWTType.LT_CONDITION, columnName, value));
            return this;
        }

        public BuiltOptions ifLesserOrEqualCondition(String columnName, Object value) {
            Validator.validateFalse(this.lwtPredicates.contains(IF_EXISTS), "Cannot add IF = XXX with IF EXISTS", new Object[0]);
            Validator.validateFalse(this.lwtPredicates.contains(IF_NOT_EXISTS), "Cannot add IF = XXX with IF NOT EXISTS", new Object[0]);
            this.lwtPredicates.add(new Options.LWTCondition(Options.LWTPredicate.LWTType.LTE_CONDITION, columnName, value));
            return this;
        }

        BuiltOptions lwtPredicates(List<Options.LWTPredicate> lwtPredicates) {
            this.lwtPredicates = lwtPredicates;
            return this;
        }

        @Deprecated
        public BuiltOptions LWTLocalSerial() {
            return this.lwtLocalSerial();
        }

        @Deprecated
        BuiltOptions LWTLocalSerial(boolean localSerial) {
            return this.lwtLocalSerial(localSerial);
        }

        public BuiltOptions lwtLocalSerial() {
            this.serialConsistencyO = Optional.fromNullable((Object)com.datastax.driver.core.ConsistencyLevel.LOCAL_SERIAL);
            return this;
        }

        BuiltOptions lwtLocalSerial(boolean localSerial) {
            if (localSerial) {
                this.serialConsistencyO = Optional.fromNullable((Object)com.datastax.driver.core.ConsistencyLevel.LOCAL_SERIAL);
            }
            return this;
        }

        BuiltOptions withAsyncListeners(List<FutureCallback<Object>> listeners) {
            this.asyncListeners = listeners;
            return this;
        }

        BuiltOptions withProxy() {
            this.createProxy = true;
            return this;
        }

        BuiltOptions withProxy(boolean createProxy) {
            this.createProxy = createProxy;
            return this;
        }
    }

    public static class NoOptions
    extends Options {
        protected NoOptions() {
        }

        @Override
        public NoOptions duplicateWithoutTtlAndTimestamp() {
            return this;
        }
    }
}

