/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internal.statement.StatementHelper;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.listener.LWTResultListener;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.ArrayUtils;

public class NativeStatementWrapper
extends AbstractStatementWrapper {
    private final CodecRegistry codecRegistry;
    private final ProtocolVersion protocolVersion;
    private Statement statement;
    private PagingState pagingState;
    private static final List<ProtocolVersion> SUPPORTED_NATIVE_PROTOCOLS = Arrays.asList(ProtocolVersion.V1, ProtocolVersion.V2, ProtocolVersion.V3);

    public NativeStatementWrapper(Configuration driverConfiguration, Class<?> entityClass, Statement statement, Object[] values, Optional<LWTResultListener> LWTResultListener2) {
        super(entityClass, values);
        this.codecRegistry = driverConfiguration.getCodecRegistry();
        this.protocolVersion = driverConfiguration.getProtocolOptions().getProtocolVersion();
        this.statement = statement;
        this.lwtResultListener = LWTResultListener2;
    }

    @Override
    public String getQueryString() {
        return StatementHelper.maybeGetQueryString(this.statement);
    }

    @Override
    public ListenableFuture<ResultSet> executeAsync(Session session, ExecutorService executorService) {
        this.activateQueryTracing();
        return super.executeAsyncInternal(session, this, executorService);
    }

    @Override
    public Statement getStatement() {
        if (this.statement instanceof RegularStatement) {
            this.statement = this.buildParameterizedStatement();
        }
        if (this.pagingState != null) {
            this.statement.setPagingState(this.pagingState);
        }
        return this.statement;
    }

    @Override
    public void logDMLStatement(String indentation) {
        if (dmlLogger.isDebugEnabled() || this.displayDMLForEntity) {
            String queryType = this.statement.getClass().getSimpleName();
            String queryString = this.getQueryString();
            String consistencyLevel = this.statement.getConsistencyLevel() == null ? "DEFAULT" : this.statement.getConsistencyLevel().name();
            this.writeDMLStatementLog(queryType, queryString, consistencyLevel, this.values);
        }
    }

    @Override
    public void releaseResources() {
    }

    public Statement buildParameterizedStatement() {
        if (this.statement instanceof RegularStatement) {
            RegularStatement regularStatement = (RegularStatement)this.statement;
            boolean statementHasNoBoundValue = ArrayUtils.isEmpty((Object[])regularStatement.getValues(this.protocolVersion, this.codecRegistry));
            if (statementHasNoBoundValue && ArrayUtils.isNotEmpty((Object[])this.values)) {
                SimpleStatement statement = new SimpleStatement(this.getQueryString(), this.values);
                statement.setFetchSize(this.statement.getFetchSize());
                statement.setKeyspace(this.statement.getKeyspace());
                statement.setConsistencyLevel(this.statement.getConsistencyLevel());
                statement.setDefaultTimestamp(this.statement.getDefaultTimestamp());
                statement.setRetryPolicy(this.statement.getRetryPolicy());
                if (this.statement.getRoutingKey(this.protocolVersion, this.codecRegistry) != null) {
                    statement.setRoutingKey(this.statement.getRoutingKey(this.protocolVersion, this.codecRegistry));
                }
                if (this.statement.getConsistencyLevel() != null) {
                    statement.setConsistencyLevel(this.statement.getConsistencyLevel());
                }
                if (this.statement.getSerialConsistencyLevel() != null) {
                    statement.setSerialConsistencyLevel(this.statement.getSerialConsistencyLevel());
                }
                return statement;
            }
            return this.statement;
        }
        return this.statement;
    }

    public void setPagingState(PagingState pagingState) {
        this.pagingState = pagingState;
    }
}

