/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.listener.LWTResultListener;
import java.util.concurrent.ExecutorService;

public class BoundStatementWrapper
extends AbstractStatementWrapper {
    private Supplier<BoundStatement> boundStatement;

    public BoundStatementWrapper(Class<?> entityClass, Supplier<BoundStatement> bs, Object[] values, ConsistencyLevel consistencyLevel, Optional<LWTResultListener> lwtResultListener, Optional<ConsistencyLevel> serialConsistencyLevel) {
        super(entityClass, values);
        this.lwtResultListener = lwtResultListener;
        this.boundStatement = Suppliers.memoize((Supplier)Suppliers.compose(this.getFunc(consistencyLevel, serialConsistencyLevel), bs));
    }

    @Override
    public ListenableFuture<ResultSet> executeAsync(Session session, ExecutorService executorService) {
        this.activateQueryTracing();
        return super.executeAsyncInternal(session, this, executorService);
    }

    public BoundStatement getStatement() {
        return (BoundStatement)this.boundStatement.get();
    }

    @Override
    public String getQueryString() {
        return ((BoundStatement)this.boundStatement.get()).preparedStatement().getQueryString();
    }

    @Override
    public void logDMLStatement(String indentation) {
        if (dmlLogger.isDebugEnabled() || this.displayDMLForEntity) {
            BoundStatement boundStatement = (BoundStatement)this.boundStatement.get();
            PreparedStatement ps = boundStatement.preparedStatement();
            String queryType = "Bound statement";
            String queryString = ps.getQueryString();
            String consistencyLevel = boundStatement.getConsistencyLevel() == null ? "DEFAULT" : boundStatement.getConsistencyLevel().name();
            this.writeDMLStatementLog(queryType, queryString, consistencyLevel, this.values);
        }
    }

    @Override
    public void releaseResources() {
        this.values = null;
    }

    private Function<BoundStatement, BoundStatement> getFunc(final ConsistencyLevel consistencyLevel, final Optional<ConsistencyLevel> serialConsistencyLevel) {
        return new Function<BoundStatement, BoundStatement>(){

            public BoundStatement apply(BoundStatement statement) {
                statement.setConsistencyLevel(consistencyLevel);
                if (serialConsistencyLevel.isPresent()) {
                    statement.setSerialConsistencyLevel((ConsistencyLevel)serialConsistencyLevel.get());
                }
                return statement;
            }
        };
    }
}

