/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.cache;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import info.archinnov.achilles.internal.context.facade.PersistentStateHolder;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.internal.statement.cache.CacheType;
import info.archinnov.achilles.internal.statement.cache.StatementCacheKey;
import info.archinnov.achilles.internal.statement.prepared.PreparedStatementGenerator;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.options.OptionsBuilder;
import info.archinnov.achilles.query.slice.SliceQueryProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManager {
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);
    static final Set<String> ALL_FIELDS = new HashSet<String>();
    private final int maxLRUCacheSize;
    private PreparedStatementGenerator generator = PreparedStatementGenerator.Singleton.INSTANCE.get();
    private Function<PropertyMeta, String> propertyExtractor = new Function<PropertyMeta, String>(){

        public String apply(PropertyMeta pm) {
            return pm.getPropertyName();
        }
    };

    public CacheManager(int maxLRUCacheSize) {
        this.maxLRUCacheSize = maxLRUCacheSize;
    }

    public PreparedStatement getCacheForFieldSelect(Session session, Cache<StatementCacheKey, PreparedStatement> dynamicPSCache, PersistentStateHolder context, PropertyMeta pm) {
        log.trace("Get cache for SELECT property {} from entity class {}", (Object)pm.getPropertyName(), (Object)pm.getEntityClassName());
        Class entityClass = context.getEntityClass();
        EntityMeta entityMeta = context.getEntityMeta();
        Set<String> clusteredFields = pm.forCache().extractClusteredFieldsIfNecessary();
        StatementCacheKey cacheKey = new StatementCacheKey(CacheType.SELECT_FIELD, clusteredFields, entityClass, OptionsBuilder.noOptions());
        PreparedStatement ps = (PreparedStatement)dynamicPSCache.getIfPresent((Object)cacheKey);
        if (ps == null) {
            ps = this.generator.prepareSelectField(session, entityMeta, pm);
            dynamicPSCache.put((Object)cacheKey, (Object)ps);
            this.displayCacheStatistics(dynamicPSCache);
        }
        return ps;
    }

    public PreparedStatement getCacheForEntityInsert(Session session, Cache<StatementCacheKey, PreparedStatement> dynamicPSCache, PersistentStateHolder context, List<PropertyMeta> pms) {
        log.trace("Get cache for INSERT properties {} from entity class {}", pms, context.getEntityClass());
        Class entityClass = context.getEntityClass();
        EntityMeta entityMeta = context.getEntityMeta();
        HashSet<String> fields = new HashSet<String>(Collections2.transform(pms, this.propertyExtractor));
        StatementCacheKey cacheKey = new StatementCacheKey(CacheType.INSERT, fields, entityClass, context.getOptions());
        PreparedStatement ps = (PreparedStatement)dynamicPSCache.getIfPresent((Object)cacheKey);
        if (ps == null) {
            ps = this.generator.prepareInsert(session, entityMeta, pms, context.getOptions());
            dynamicPSCache.put((Object)cacheKey, (Object)ps);
            this.displayCacheStatistics(dynamicPSCache);
        }
        return ps;
    }

    public PreparedStatement getCacheForFieldsUpdate(Session session, Cache<StatementCacheKey, PreparedStatement> dynamicPSCache, PersistentStateHolder context, List<PropertyMeta> pms) {
        log.trace("Get cache for UPDATE properties {} from entity class {}", pms, context.getEntityClass());
        Class entityClass = context.getEntityClass();
        EntityMeta entityMeta = context.getEntityMeta();
        HashSet<String> fields = new HashSet<String>(Collections2.transform(pms, this.propertyExtractor));
        StatementCacheKey cacheKey = new StatementCacheKey(CacheType.UPDATE_FIELDS, fields, entityClass, context.getOptions());
        PreparedStatement ps = (PreparedStatement)dynamicPSCache.getIfPresent((Object)cacheKey);
        if (ps == null) {
            ps = this.generator.prepareUpdateFields(session, entityMeta, pms, context.getOptions());
            dynamicPSCache.put((Object)cacheKey, (Object)ps);
            this.displayCacheStatistics(dynamicPSCache);
        }
        return ps;
    }

    public PreparedStatement getCacheForDeletion(Session session, Cache<StatementCacheKey, PreparedStatement> dynamicPSCache, PersistentStateHolder context) {
        log.trace("Get cache for DELETE from entity class {}", context.getEntityClass());
        Class entityClass = context.getEntityClass();
        EntityMeta entityMeta = context.getEntityMeta();
        Options options = context.getOptions();
        StatementCacheKey cacheKey = new StatementCacheKey(CacheType.DELETE_PARTITION, ALL_FIELDS, entityClass, options);
        PreparedStatement ps = (PreparedStatement)dynamicPSCache.getIfPresent((Object)cacheKey);
        if (ps == null) {
            ps = this.generator.prepareDeletePS(session, entityMeta, options);
            dynamicPSCache.put((Object)cacheKey, (Object)ps);
            this.displayCacheStatistics(dynamicPSCache);
        }
        return ps;
    }

    public PreparedStatement getCacheForCollectionAndMapOperation(Session session, Cache<StatementCacheKey, PreparedStatement> dynamicPSCache, PersistentStateHolder context, PropertyMeta pm, DirtyCheckChangeSet changeSet) {
        Class entityClass = context.getEntityClass();
        CollectionAndMapChangeType changeType = changeSet.getChangeType();
        log.trace("Get cache for operation {} on entity class {} and property {}", new Object[]{changeType.name(), entityClass, pm.getPropertyName()});
        StatementCacheKey cacheKey = new StatementCacheKey(changeType.cacheType(), Sets.newHashSet((Object[])new String[]{pm.getPropertyName()}), entityClass, context.getOptions());
        PreparedStatement ps = (PreparedStatement)dynamicPSCache.getIfPresent((Object)cacheKey);
        if (ps == null) {
            ps = this.generator.prepareCollectionAndMapUpdate(session, context.getEntityMeta(), changeSet, context.getOptions());
            dynamicPSCache.put((Object)cacheKey, (Object)ps);
            this.displayCacheStatistics(dynamicPSCache);
        }
        return ps;
    }

    public PreparedStatement getCacheForSliceSelectAndIterator(Session session, Cache<StatementCacheKey, PreparedStatement> dynamicPSCache, SliceQueryProperties sliceQueryProperties) {
        StatementCacheKey cacheKey = new StatementCacheKey(CacheType.SLICE_QUERY_SELECT, sliceQueryProperties);
        PreparedStatement ps = (PreparedStatement)dynamicPSCache.getIfPresent((Object)cacheKey);
        if (ps == null) {
            ps = this.generator.prepareSelectSliceQuery(session, sliceQueryProperties);
            dynamicPSCache.put((Object)cacheKey, (Object)ps);
            this.displayCacheStatistics(dynamicPSCache);
        }
        return ps;
    }

    public PreparedStatement getCacheForSliceDelete(Session session, Cache<StatementCacheKey, PreparedStatement> dynamicPSCache, SliceQueryProperties sliceQueryProperties) {
        StatementCacheKey cacheKey = new StatementCacheKey(CacheType.SLICE_QUERY_DELETE, sliceQueryProperties);
        PreparedStatement ps = (PreparedStatement)dynamicPSCache.getIfPresent((Object)cacheKey);
        if (ps == null) {
            ps = this.generator.prepareDeleteSliceQuery(session, sliceQueryProperties);
            dynamicPSCache.put((Object)cacheKey, (Object)ps);
            this.displayCacheStatistics(dynamicPSCache);
        }
        return ps;
    }

    private void displayCacheStatistics(Cache<StatementCacheKey, PreparedStatement> dynamicPSCache) {
        long cacheSize = dynamicPSCache.size();
        CacheStats cacheStats = dynamicPSCache.stats();
        log.info("Total LRU cache size {}", (Object)cacheSize);
        if ((double)cacheSize > (double)this.maxLRUCacheSize * 0.8) {
            log.warn("Warning, the LRU prepared statements cache is over 80% full");
        }
        if (log.isDebugEnabled()) {
            log.debug("Cache statistics :");
            log.debug("\t\t- hits count : {}", (Object)cacheStats.hitCount());
            log.debug("\t\t- hits rate : {}", (Object)cacheStats.hitRate());
            log.debug("\t\t- miss count : {}", (Object)cacheStats.missCount());
            log.debug("\t\t- miss rate : {}", (Object)cacheStats.missRate());
            log.debug("\t\t- eviction count : {}", (Object)cacheStats.evictionCount());
            log.debug("\t\t- load count : {}", (Object)cacheStats.loadCount());
            log.debug("\t\t- load success count : {}", (Object)cacheStats.loadSuccessCount());
            log.debug("\t\t- load exception count : {}", (Object)cacheStats.loadExceptionCount());
            log.debug("\t\t- total load time : {}", (Object)cacheStats.totalLoadTime());
            log.debug("\t\t- average load penalty : {}", (Object)cacheStats.averageLoadPenalty());
            log.debug("");
            log.debug("");
        }
    }
}

