/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy.wrapper;

import com.google.common.collect.Sets;
import info.archinnov.achilles.internal.proxy.wrapper.AbstractWrapper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSetWrapper
extends AbstractWrapper
implements Set<Object> {
    private static final Logger log = LoggerFactory.getLogger(UpdateSetWrapper.class);

    @Override
    public boolean add(Object element) {
        log.trace("Mark set property {} of entity class {} dirty upon element addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Object rawElement = this.proxifier.removeProxy(element);
        this.getDirtyChecker().addElements(Sets.newHashSet((Object[])new Object[]{rawElement}));
        return true;
    }

    @Override
    public boolean addAll(Collection<?> elements) {
        log.trace("Mark set property {} of entity class {} dirty upon elements addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Collection<?> rawElements = this.proxifier.removeProxy(elements);
        if (!rawElements.isEmpty()) {
            this.getDirtyChecker().addElements(Sets.newHashSet(rawElements));
        }
        return true;
    }

    @Override
    public void clear() {
        log.trace("Mark set property {} of entity class {} dirty upon clearance", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        this.getDirtyChecker().removeAllElements();
    }

    @Override
    public boolean contains(Object arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Iterator<Object> iterator() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public boolean remove(Object element) {
        log.trace("Mark set property {} of entity class {} dirty upon element removal", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Object rawElement = this.proxifier.removeProxy(element);
        this.getDirtyChecker().removeElements(Sets.newHashSet((Object[])new Object[]{rawElement}));
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        log.trace("Mark set property {} of entity class {} dirty upon elements removal", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Collection<?> rawElements = this.proxifier.removeProxy(elements);
        this.getDirtyChecker().removeElements(Sets.newHashSet(rawElements));
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }
}

