/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy.wrapper;

import com.google.common.base.Optional;
import info.archinnov.achilles.internal.proxy.wrapper.AbstractWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMapWrapper
extends AbstractWrapper
implements Map<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(UpdateMapWrapper.class);

    @Override
    public void clear() {
        log.trace("Mark map property {} of entity class {} dirty upon all elements clearance", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        this.getDirtyChecker().removeAllElements();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Object get(Object key) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Object put(Object key, Object element) {
        log.trace("Mark map property {} of entity class {} dirty upon new value {} addition for key {}", new Object[]{this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName(), element, key});
        Object rawElement = this.proxifier.removeProxy(element);
        HashMap<Object, Object> entries = new HashMap<Object, Object>();
        entries.put(key, rawElement);
        this.getDirtyChecker().addElements(entries);
        return Optional.absent();
    }

    @Override
    public void putAll(Map<?, ?> map) {
        log.trace("Mark encodedMap property {} of entity class {} dirty upon new key/value pairs addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        HashMap<Object, Object> encodedMap = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object element = this.proxifier.removeProxy(entry.getValue());
            Object key = this.proxifier.removeProxy(entry.getKey());
            encodedMap.put(key, element);
        }
        if (encodedMap.size() > 0) {
            this.getDirtyChecker().addElements(encodedMap);
        }
    }

    @Override
    public Object remove(Object key) {
        log.trace("Mark map property {} of entity class {} dirty upon removal of value havo,g key {}", new Object[]{this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName(), key});
        Object element = this.proxifier.removeProxy(key);
        this.getDirtyChecker().removeMapEntry(element);
        return Optional.absent();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    public Map<Object, Object> getTarget() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }
}

